% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{pairwise_correlation}
\alias{pairwise_correlation}
\title{Pairwise correlation}
\usage{
pairwise_correlation(C, U)
}
\arguments{
\item{C}{A matrix. The correlation or covariance matrix (p x p).}

\item{U}{A matrix. Each column correspond to an p-dimensional PC.}
}
\value{
A float matrix (r x r).
}
\description{
Computes the pairwise correlations between PCs defined as \eqn{u_{t}^\top C u_{s}}.
}
\examples{
library(datasets)
TestMat <- cor(datasets::mtcars)
mspcares <- mspca(TestMat, 2, c(4,4))
pairwise_correlation(TestMat, mspcares$x_best)
}
