% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_timerelated.R
\name{time_plot_interval}
\alias{time_plot_interval}
\title{Plot periods of events}
\usage{
time_plot_interval(
  dt,
  xlab = "DateTime",
  ylab = "ID",
  legend_title = "Group",
  arrow_wt = 1,
  arrow_color = "black"
)
}
\arguments{
\item{dt}{a \code{data.frame} with the following columns
\describe{
  \item{id}{for ID of each interval}
  \item{idn}{for order of ID}
  \item{start}{for starting time}
  \item{end}{for ending time with arrow head}
  \item{label}{for labeling the starting time}
}}

\item{xlab}{A string for the label of X-axis}

\item{ylab}{A string for the label of Y-axis}

\item{legend_title}{A string for the title of legend}

\item{arrow_wt}{An integer for the weight of arrow}

\item{arrow_color}{A string for the color of arrow}
}
\value{
a plot
}
\description{
Create a plot for event periods by ID
}
\examples{
library(ggplot2)
dt = data.frame( id=c('ID01','ID12','ID3'), idn=c(1,3,2), start=1800*c(0,1,2), end=1800*c(2,-1,3),
label=c('A','B','C') )
time_plot_interval( dt, xlab='Time', ylab='ID', legend_title='Group', arrow_wt=3,
arrow_color='gray')

}
