% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitCube_BFN2.R
\docType{class}
\name{unitCube_BFN2-class}
\alias{unitCube_BFN2-class}
\alias{unitCube_BFN2}
\title{An S4 class to represent the function \eqn{\prod^{n}_{i=1} i\cos(ix_i)} on \eqn{[0,1]^n}}
\description{
Implementation of the function
\deqn{f \colon [0,1]^n \to (-\infty,\infty),\, \vec{x} \mapsto f(\vec{x}) = \prod^{n}_{i=1} i\cos(ix_i)},
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{C_n = [0,1]^n}.
The integral is known to be
\deqn{\int_{C_n} f(\vec{x}) d\vec{x} = \prod^{n}_{i=1}\sin(i).}
}
\details{
The instance needs to be created with one parameter representing the dimension \eqn{n}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}
}}

\examples{
n <- as.integer(3)
f <- new("unitCube_BFN2",dim=n)
}
\author{
Klaus Herrmann
}
