% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiModTest.R
\name{mglm.test}
\alias{mglm.test}
\title{Modality Assessment in Multimodal Generalized Linear Models}
\usage{
mglm.test(
  X,
  y,
  mod.idx,
  family = c("gaussian", "binomial"),
  iter = TRUE,
  penalty = c("SCAD", "MCP", "lasso"),
  tune = c("bic", "ebic", "aic"),
  lambda = NULL,
  nlambda = 100,
  conf.level = 0.95,
  CI.type = c("two.sided", "one.sided"),
  trace = FALSE
)
}
\arguments{
\item{X}{The \eqn{n \times p} data matrix consisting of features from all modalities.}

\item{y}{The \eqn{n \times 1} vector of response.}

\item{mod.idx}{A list of column indices for all modalities in the concatenated data matrix \code{X}.}

\item{family}{A description of the error distribution and link function to be used in the model.
Currently, we allow the Binomial ("binomial") and
Gaussian ("gaussian") families with canonical links only.}

\item{iter}{Specifies whether to perform iterative SIS. The default is
\code{iter=TRUE}.}

\item{penalty}{Specifies the type of penalty to be used in the variable selection and
inference procedure.
Options include \code{'MCP'}, \code{'SCAD'}, and \code{'lasso'}. The default is \code{penalty='SCAD'}.}

\item{tune}{Specifies the method for selecting the optimal tuning parameters in (I)SIS and
penalized likelihood procedure. Options include \code{'bic'}, \code{'ebic'} and \code{'aic'}.
The default is \code{tune='bic'}.}

\item{lambda}{A user-specified decreasing sequence of lambda values for penalized likelihood
procedure. By default, a sequence of values of length \code{nlambda} is automatically computed and
equally spaced on the log scale.}

\item{nlambda}{The number of lambda values. The default is 100.}

\item{conf.level}{Levels of the confidence interval. The default is \code{conf.level=0.95}.}

\item{CI.type}{A string specifying the type of the confidence interval. Options include
\code{'two.sided'} and \code{'one.sided'}. The default is \code{CI.type='two.sided'}.}

\item{trace}{Specifies whether to print out logs of iterations in SIS procedure. The default is
\code{trace=FALSE}.}
}
\value{
An object with S3 class "mglm.test" containing:
\item{sel.idx}{ List of indices of selected features by (I)SIS in each modality.}
\item{num.nonzeros}{Number of selected features by (I)SIS in each modality.}
\item{ERE}{Point estimation of ERE for each modality.}
\item{ERE.CI.L}{Lower bound of the confidence interval of ERE for each modality}
\item{ERE.CI.U}{Upper bound of the confidence interval of ERE for each modality}
\item{R2}{Point estimate of pseudo-\eqn{R^2} for each modality.}
\item{R2.CI.L}{Lower bound of the confidence interval of pseudo-\eqn{R^2} for each modality}
\item{R2.CI.U}{Upper bound of the confidence interval of pseudo-\eqn{R^2} for each modality}
\item{conf.level}{ Level of confidence intervals.}
}
\description{
Provides statistical inference for modality-specific information gain in
multimodal GLMs. Estimates ERE and pseudo-R² with confidence intervals and p-values using
Sure Independence Screening for variable selection and penalized likelihood for inference.
}
\examples{
## Example 1: Linear model
data(data_linear_model)
X <- data_linear_model$X
y <- data_linear_model$y
mod.idx <- data_linear_model$mod.idx
test <- mglm.test(X = X, y = y, mod.idx = mod.idx, family = "gaussian",
               iter = TRUE, penalty = "SCAD", tune = "bic",
               conf.level = 0.95, CI.type = "one.sided")
summary(test)


## Example 2: Logistic regression
data(data_logistic_model)
X <- data_logistic_model$X
y <- data_logistic_model$y
mod.idx <- data_logistic_model$mod.idx
test <- mglm.test(X = X, y = y, mod.idx = mod.idx, family = "binomial",
               iter = TRUE, penalty = "SCAD", tune = "bic",
               conf.level = 0.95, CI.type = "two.sided")
sum.test <- summary(test)



}
