% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-s4-class.R
\docType{class}
\name{Dfishery-class}
\alias{Dfishery-class}
\title{Dfishery S4 object}
\description{
S4 class that organizes the various data inputs for the MSA model. \code{MSAdata} simply inherits the slots from 6 component classes:
\code{Dmodel}, \code{Dstock}, \code{Dfishery}, \code{Dsurvey} \code{DCKMR}, and \code{Dtag}, where the \code{D}- prefix denotes an object for data inputs (or model configuration).
}
\details{
For convenience, most arrays and matrices have the associated dimensions in the variable name. For example, \code{Cobs_ymfr} represents
observed catch with the dimension following the underscore, following this template:

\tabular{ll}{
\code{y} \tab Year \cr
\code{m} \tab Season \cr
\code{a} \tab Age \cr
\code{r} \tab Region \cr
\code{f} \tab Fishery \cr
\code{i} \tab Index \cr
\code{s} \tab Stock
}
}
\section{Slots inherited from Dfishery}{

\describe{
\item{\code{nf}}{Integer, number of fleets}
\item{\code{Cobs_ymfr}}{Total fishery catch}
\item{\code{Csd_ymfr}}{Lognormal standard deviation of the fishery catch. Only used if \code{Dmodel@condition = "F"}. Default of 0.01.}
\item{\code{fwt_ymafs}}{Fishery weight at age. Set to 1 when fleet catch is in units of abundance. Set to stock weight at age by default (values at beginning of time step).}
\item{\code{CAAobs_ymafr}}{Fishery catch at age composition}
\item{\code{CALobs_ymlfr}}{Fishery catch at length composition}
\item{\code{fcomp_like}}{Character, likelihood for the fishery composition data. See \code{type} argument of \code{\link[=like_comp]{like_comp()}} for options}
\item{\code{CAAN_ymfr}}{Sample size of the catch at age vector by season if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{CALN_ymfr}}{Sample size of the catch at length vector by season if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{CAAtheta_f}}{Catch at age dispersion parameter if using the Dirichlet-multinomial likelihood. Default set to 1.}
\item{\code{CALtheta_f}}{Catch at length dispersion parameter if using the Dirichlet-multinomial likelihood. Default set to 1.}
\item{\code{sel_block_yf}}{Index of dummy fleets to model time blocks of selectivity}
\item{\code{sel_f}}{Character vector of the functional form for selectivity. Choose between: \verb{"logistic_length", "dome_length", "logistic_age", "dome_age", "SB", "B"}}
\item{\code{Cinit_mfr}}{Equilibrium seasonal catch prior to the first year. One way to initialize the abundance at the start of the first year
in the model. Default of zero.}
\item{\code{SC_ymafrs}}{Stock composition data.}
\item{\code{SC_aa}}{Boolean matrix that aggregates age classes for the stock composition data. See example.}
\item{\code{SC_ff}}{Boolean matrix that aggregates fleets for the stock composition data. See example.}
\item{\code{SC_like}}{Character, likelihood for the stock composition data. See \code{type} argument of \code{\link[=like_comp]{like_comp()}} for options}
\item{\code{SCN_ymafr}}{Sample size of the stock composition vector if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{SCtheta_f}}{Stock composition dispersion parameter if using the Dirichlet-multinomial likelihood. Default set to 1.}
\item{\code{SCstdev_ymafrs}}{Stock composition standard deviation if using the lognormal likelihood. Default set to 0.1.}
}
}

\examples{
# Aggregate stock composition for ages 1-4 and 5-10 across all fleets
na <- 10
na_SC <- 2
SC_aa <- matrix(0, na_SC, na) # Assumes dim(SC_ymafrs)[3] = na_SC
SC_aa[1, 1:4] <- SC_aa[2, 5:10] <- 1

nf <- 3
nf_SC <- 1
SC_ff <- matrix(1, nf_SC, nf) # Assumes dim(SC_ymafrs)[4] <- nf_SC

}
\seealso{
\link{MSAdata-class} \code{\link[=check_data]{check_data()}} \link{Dmodel-class} \link{Dstock-class} \link{Dfishery-class} \link{Dsurvey-class} \link{DCKMR-class} \link{Dtag-class}
}
