% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{MultiLandMetrics-class}
\alias{MultiLandMetrics-class}
\title{Class 'MultiLandMetrics'}
\description{
Objects of class \code{MultiLandMetrics} are returned by \code{\link[=mland_metrics]{mland_metrics()}}. It holds all the information
relative to the metrics that were calculated by the parameters inputted by the user. This object
class can be passed to functions \code{\link[=metrics_corr]{metrics_corr()}}, \code{\link[=metrics_plots]{metrics_plots()}}, \code{\link[=metrics_filter]{metrics_filter()}}, \code{\link[=metrics_gradient]{metrics_gradient()}} and
\code{\link[=metrics_bind]{metrics_bind()}} for further analyses.
}
\section{Slots}{

\describe{
\item{\code{call}}{The call when function \code{\link[=mland_metrics]{mland_metrics()}} was called.}

\item{\code{idkey}}{A unique identification id for the 'MultiLandMetrics' object.}

\item{\code{crs_proj}}{A string depicting the CRS of points layer.}

\item{\code{n_layers}}{Number of raster layers from which metrics were calculated.}

\item{\code{rast_names}}{A list with dataframes containing the names of the raster layers of the
'MultiLand' object the function \code{\link[=mland_metrics]{mland_metrics()}} worked with.}

\item{\code{classes}}{A data.frame depicting the raster layers, classes and classes names from which
metrics were calculated.}

\item{\code{n_classes}}{Numeric vector depicting the number of distinct classes per raster layer
from which metrics were calculated.}

\item{\code{points}}{A data.frame containing points coordinates and other attributes.}

\item{\code{n_points}}{Number of points from which metrics were calculated.}

\item{\code{site_names}}{Logical. Whether points have associated site names or not.}

\item{\code{radii}}{Distinct radii from which metrics were calculated.}

\item{\code{metrics}}{A data.frame depicting the metrics that were calculated, classified by level.}

\item{\code{data}}{Main data.frame with the values of the metrics that were calculated for each
point, radius, raster layers and other parameters pre-defined by the user.}

\item{\code{ext_calcs}}{A data.frame depicting the extra calculations that were made in given extra
raster layers.}
}}

\examples{
# Shows information of object 'MultiLandMetrics'
ed_metrics
otf_metrics
}
