% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{R2.merMod}
\alias{R2.merMod}
\title{merMod method for R2}
\usage{
\method{R2}{merMod}(object, cluster = FALSE, ...)
}
\arguments{
\item{object}{A model estimated by \code{lmer}.}

\item{cluster}{A logical whether to calculate individual pseudo R2 values by
cluster unit (if \code{TRUE}) or the marginal and conditional R2 for the
overall model (if \code{FALSE}, the default).}

\item{...}{Added for consistency with generic. Not currently used.}
}
\value{
a named vector with the marginal and conditional R2 values,
  if \code{CLUSTER = FALSE}, otherwise, a data table with the pseudo R2
  for each cluster unit.
}
\description{
For pseudo R2 by cluster, the squared correlation between observed
and predicted values for each cluster unit is returned.  For the overall model,
the marginal and conditional R2 are calculated as described in the references.
}
\examples{

library(JWileymisc)
data(aces_daily, package = "JWileymisc")
m1 <- lme4::lmer(PosAff ~ STRESS + (1 + STRESS | UserID),
  data = aces_daily)

R2(m1)
R2(m1, cluster = TRUE)

hist(R2(m1, cluster = TRUE)$R2)

rm(m1)
}
\references{
For estimating the marginal and conditional R-squared values,
  see:
  Nakagawa, S. and Schielzeth, H. (2013) <doi:10.1111/j.2041-210x.2012.00261.x>
  "A general and simple method for obtaining R2 from generalized linear mixed-effects models"
  and also:
  Johnson, P. C. (2014) <doi:10.1111/2041-210X.12225>
  "Extension of Nakagawa & Schielzeth's R2GLMM to random slopes models"
}
\keyword{utils}
