% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.brmcoda}
\alias{update.brmcoda}
\title{Update \code{\link{brmcoda}} models}
\usage{
\method{update}{brmcoda}(object, formula. = NULL, newdata = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{\link{brmcoda}} object to be updated.}

\item{formula.}{Changes to the formula; for details see
\code{\link[stats:update.formula]{update.formula}} and \code{\link[brms:brmsformula]{brmsformula}}.}

\item{newdata}{A \code{data.frame} or \code{data.table}
containing data of all variables used in the analysis.
It must include a composition and the same ID variable as the existing \code{\link{complr}} object.}

\item{...}{Further arguments passed to \code{\link[brms:brm]{brm}}.}
}
\value{
A \code{\link{brmcoda}} with two elements
\item{\code{complr}}{ An object of class \code{complr} used in the \code{brm} model. }
\item{\code{model}}{ An object of class \code{brmsfit}, which contains the posterior draws
along with many other useful information about the model.}
}
\description{
This method allows for updating an existing \code{\link{brmcoda}} object.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){

# model with compositional predictor at between and within-person levels
fit <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID"),
                formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                   wz1_1 + wz2_1 + wz3_1 + wz4_1 + Female + (1 | ID),
                chain = 1, iter = 500,
              backend = "cmdstanr")

# removing the effect of bz1_1
fit1 <- update(fit, formula. = ~ . - bz1_1)

# using only a subset
fit2 <- update(fit, newdata = mcompd[ID != 1])
}}
}
\seealso{
\code{\link{brmcoda}}
}
