% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{mediators,multimedia-method}
\alias{mediators,multimedia-method}
\title{Names of Mediators in a Multimedia Object}
\usage{
\S4method{mediators}{multimedia}(object)
}
\arguments{
\item{object}{An object of class multimedia.}
}
\value{
m A vector of strings containing the names of all the mediators.
}
\description{
This is a helper that returns the names of the mediator variables in an
object of class multimedia. It parses the graph in the DAG specifying the
mediation analysis, and it returns all variables between treatment and
outcome.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    mediators()
}
