% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimediate.R
\name{multimediate}
\alias{multimediate}
\title{multimediate}
\usage{
multimediate(
  lmodel.m,
  correlated = FALSE,
  model.y,
  treat,
  treat.value = 1,
  control.value = 0,
  J = 1000,
  conf.level = 0.95,
  fun = mean,
  data = NULL,
  peryr = 1e+05,
  verbose = TRUE
)
}
\arguments{
\item{lmodel.m}{list of fitted models object for mediators. Can be of class 'lm', 'polr','glm'.}

\item{correlated}{a logical value. if 'FALSE' a identity matrix is used for the matrix of correlation of mediators; if 'TRUE' matrix of correlation is estimated. Default is 'FALSE'.}

\item{model.y}{a fitted model object for the outcome. Can be of class 'lm', 'polr','glm' or 'aalen'.}

\item{treat}{a character string indicating the name of the treatment variable used in the models. The treatment can be either binary (integer or a two-valued factor) or continuous (numeric).}

\item{treat.value}{value of the treatment variable used as the treatment condition. Default is 1.}

\item{control.value}{value of the treatment variable used as the control condition. Default is 0.}

\item{J}{number of Monte Carlo draws for quasi-Bayesian approximation.}

\item{conf.level}{level of the returned two-sided confidence intervals. Default is to return the 2.5 and 97.5 percentiles of the simulated quantities.}

\item{fun}{the function used to compute the point estimate of the effects of interest from its empirical distribution. The function mean or median can be used. Default is the function mean.}

\item{data}{dataset with all variables used in the mediator and outcome models}

\item{peryr}{the number of person-years to multiply the additive estimator to obtain results in scale of cases per person-years (only applicable to the survival outcome)}

\item{verbose}{Logical. If `TRUE` (default), messages and a progress bar are displayed during execution.}
}
\value{
multimediate returns an object of class \code{mm}, a list that contains at least the components listed below.
The function \code{summary} (i.e., \code{summary.mm}) can be used to obtain a table of the results.
\itemize{
  \item \code{model.y}: the fitted outcome model.
  \item \code{model.m}: a list of fitted mediator models, one for each mediator.
  \item \code{treatment}: a character string indicating the name of the treatment variable used in the models.
  \item \code{treat.value}: value of the treatment variable used as the treatment condition.
  \item \code{control.value}: value of the treatment variable used as the control condition.
  \item \code{sims}: the number of Monte Carlo draws for quasi-Bayesian approximation.
}
}
\description{
\code{multimediate} estimates several quantities in causal mediation analysis, including the average causal mediation effect (indirect effect), average direct effect, proportion mediated, and total effect, in the presence of multiple uncausally related mediators.
}
\details{
For binary outcomes, it also estimates average causal mediation effects on the odds ratio (OR) and log-odds (logOR) scales.

For survival outcomes, \code{multimediate} additionally estimates average causal mediation effects on cases per person-year scale.
}
\examples{
# Load example data
data(data1)
summary(data1)

# Fit mediator models
M1reg <- lm(M1 ~ Treatment + C1 + C2, data = data1)
M2reg <- lm(M2 ~ Treatment + C1 + C3, data = data1)
M3reg <- lm(M3 ~ Treatment + C1, data = data1)

# Fit outcome model
Yreg <- lm(Outcome ~ Treatment + M1 + M2 + M3 + C1 + C2 + C3, data = data1)

# Perform multiple mediation analysis (may take some time)

med.analysis <- multimediate(
  lmodel.m = list(M1reg, M2reg, M3reg),
  correlated = TRUE,
  model.y = Yreg,
  treat = "Treatment",
  treat.value = 1,
  control.value = 0,
  J = 250,
  conf.level = 0.95,
  verbose = FALSE
)

summary(med.analysis, opt = "avg")

}
\references{
Jérolon, A., Baglietto, L., Birmelé, E., Alarcon, F., & Perduca, V. (2021).
Causal mediation analysis in presence of multiple mediators uncausally related.
\emph{The International Journal of Biostatistics}, 17(2), 191–221.
doi:10.1515/ijb-2019-0088

Domingo-Relloso A, Jerolon A, Tellez-Plaza M, Bermudez JD.
Causal mediation for uncausally related mediators in the context of survival analysis.
medRxiv [Preprint]. 2024 Feb 18:2024.02.16.24302923.
doi: 10.1101/2024.02.16.24302923
}
