% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mm.R
\name{plot.mm}
\alias{plot.mm}
\title{plot.mm}
\usage{
\method{plot}{mm}(
  x,
  treatment = NULL,
  logit = "logOR",
  labels = NULL,
  effect.type = c("indirect", "direct", "total"),
  xlim = NULL,
  ylim = NULL,
  xlab = "",
  ylab = "",
  main = "Estimates and confidence intervals",
  is.legend = TRUE,
  lwd = 1.5,
  cex = 0.85,
  col = "black",
  ...
)
}
\arguments{
\item{x}{element of the class "mm".}

\item{treatment}{a character string indicating the baseline treatment value of the estimated causal mediation effect and direct effect to plot. Can be either "control", "treated", "average" or "three". If "NULL"(default), three sets of estimates are plotted.}

\item{logit}{a character string indicating, when the outcome is binary, the scale of the average causal effects. "effects" for average causal effects, " OR" average causal effects on OR scale, "logOR" average causal effects on logOR scale.}

\item{labels}{a vector of character strings indicating the labels for estimated effects. The default labels wiil be used if NULL.}

\item{effect.type}{a vector indicating which quantities of interest to plot. Default is to plot all three quantities (indirects, direct and total effects).}

\item{xlim}{range of the horizontal axis.}

\item{ylim}{range of the vertical axis.}

\item{xlab}{label of the horizontal axis.}

\item{ylab}{label of the vertical axis.}

\item{main}{main title.}

\item{is.legend}{a logical value indicating the presence of the legend on top right. If the legend obscures some results, is.legend can be switched to "FALSE" or the x-axis can be changed manually with the parameters xlim.}

\item{lwd}{width of the horizontal bars for confidence intervals.}

\item{cex}{size of the dots for point estimates.}

\item{col}{color of the dots and horizontal bars for the estimates.}

\item{...}{additional parameters passed to 'plot'.}
}
\value{
plot summarizing the causal analysis
}
\description{
\code{plot.mm} is used to display the results of the mediation analyzes done with \code{multimediate}.
}
\keyword{internal}
