% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_multilevel.R
\name{layout_multilevel}
\alias{layout_multilevel}
\title{Layout for multilevel networks}
\usage{
layout_multilevel(x, layout = igraph::layout_with_fr)
}
\arguments{
\item{x}{a graph object. Must be a multilevel network.}

\item{layout}{The chosen layout algorithm. A function layout of the 'igraph'
package without parentheses. Default set to 'Fruchterman-Reingold'.}
}
\value{
A two- or three-column matrix, each row giving the coordinates of
  a vertex, according to the ids of the vertex ids.
}
\description{
Set layout coordinates for multilevel networks from a chosen
  algorithm
}
\details{
In order to facilitate the visualization of multilevel networks, higher
  level nodes are set in the upper part of the plane and the lower level
  nodes are set in the lower part of the plane.
}
\examples{
# Check if the network is multilevel
is_multilevel(linked_sim)

# Generate the layout (x,y) coordinates
l <- layout_multilevel(linked_sim)

# Plot the graph using the layout
plot(linked_sim, layout = l)

# Using Kamada Kawai algorithm
l.kk <- layout_multilevel(linked_sim, layout = igraph::layout_with_kk)

# Plot the graph with the new layout
plot(linked_sim, layout = l.kk)

}
\seealso{
\code{\link[igraph]{layout_}}
}
\author{
Neylson Crepalde, \email{neylsoncrepalde@gmail.com}
}
