% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theory.R
\name{tc}
\alias{tc}
\title{Transpositional combination & pitch multiplication}
\usage{
tc(set, multiplier = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{multiplier}{Numeric vector of transposition levels to apply to \code{set}. If not
specified, defaults to \code{set}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector of length \eqn{\leq} \code{length(set)} \eqn{\cdot} \code{length(multiplier)}
}
\description{
Cohn (1988, \doi{doi:10.2307/745790}) defines transpositional
combination as a procedure that generates a pc-set as the union of two
(or more) transpositions of some smaller set. \code{tc()} takes the small set
and a vector of transposition levels, returning the larger pc-set that
results. (Pierre Boulez referred to this procedure as pitch "multiplication",
which Amiot (2016, \doi{doi:10.1007/978-3-319-45581-5}) shows to be not at
all fanciful, as a convolution of two pitch-class sets.)
}
\examples{
tc(c(0, 4), c(0, 7))
tc(c(0, 7), c(0, 4))

pyth_tetrachord <- j(1, t, dt, 4)
pyth_dia <- tc(pyth_tetrachord, j(1, 5))
same_hue(pyth_dia, c(0, 2, 4, 5, 7, 9, 11))

}
