% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{filterOutIterations}
\alias{filterOutIterations}
\title{Remove Iterations that Generated Outlier Results.}
\usage{
filterOutIterations(wall, hall, cnt_errors, cnt_reconstructed, params)
}
\arguments{
\item{wall}{numeric matrix combining w results from all iterations}

\item{hall}{numeric matrix combining h results from all iterations}

\item{cnt_errors}{numeric matrix combining all residuals from all iterations}

\item{cnt_reconstructed}{numeric matrix combining fitted values from all iterations}

\item{params}{list including alll parameters for running the analysis}
}
\value{
list including all data required for running the subsequent stability check
}
\description{
Internal function from the WTSI framework, ported to R. This is a core 
function called from within a deconvoluteMutCounts() call. This
function removes iterations that generated outlier results.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
