% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_branch.R
\name{formula_branch}
\alias{formula_branch}
\title{Create a new formula branch.}
\usage{
formula_branch(..., covariates = NULL, name = NULL)
}
\arguments{
\item{...}{branch definition expressions.}

\item{covariates}{(optional) A character vector of optional covariates.
Each unique combination of the supplied covariates is translated into
a unique branch option. See Details.}

\item{name}{(optional) Name for the new formula.}
}
\value{
a \code{formula_branch} object.
}
\description{
The function specifies the model formula for fitting `lm_mverse()` and
`glm_mverse()`. You can list the model specification formulae individually
or use \code{covariates} option paired with one or more formulae.
}
\details{
The optional argument \code{covariates} is allows you to specify a set of
optional covariates in addition to other independent variable such as
treatment variables and blocking variables which are specified using formula.
For each covariate provided, a branch is added to the multiverse with the
option to include or exclude the covariate in the model.

For example, \code{formula_branch(y ~ x, covariates = c("c1", "c2"))} creates
the following 4 model specifications:

\code{y ~ x}

\code{y ~ x + c1}

\code{y ~ x + c2}

\code{y ~ x + c1 + c2}

Here, \code{y} is the outcome variable and \code{x} may be a treatment
variable in an experiment setting. \code{c1} and \code{c2} may be additional
covariates about the experiment units that may or may not be relevant.
}
\examples{
# Define a formula branch.
model_specifications <- formula_branch(
  y ~ MasFem,
  y ~ MasFem + hurricane_strength,
  y ~ MasFem * hurricane_strength
)
# Create a mverse, add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_formula_branch(model_specifications)
# Specify the covariates separately.
model_specifications <- formula_branch(
  y ~ MasFem,
  covariates = c("hurricane_strength", "Year", "Category", "NDAM")
)
model_specifications
}
\seealso{
Other formula branch functions: 
\code{\link{add_formula_branch}()}
}
\concept{formula branch functions}
