% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvlinks.R
\name{mvlinks}
\alias{mvlinks}
\alias{mvprobit}
\alias{mvlogit}
\title{Multivariate link functions in mvord}
\usage{
mvprobit()

mvlogit(df = 8L)
}
\arguments{
\item{df}{integer specifying the degrees of freedom of the t copula}
}
\value{
The functions \code{mvlogit()} and \code{mvprobit()} returns an object
of \code{\link{class}} \code{'mvlink'}.
An object of \code{\link{class}} \code{'mvlink'} is a list containing the following components:

\describe{
 \item{\code{name}}{

 name of the multivariate link function}
  \item{\code{df}}{

  degrees of freedom of the t copula; returned only for \code{mvlogit()}
  }
 \item{\code{F_uni}}{

  a function corresponding to the univariate margins of the
  multivariate distribution \eqn{F}  of the subject errors; the function returns \eqn{Pr(X \leq x) = F_1(x)}
  }
  \item{\code{F_biv}}{

  a function corresponding to the bivariate distribution of the
  multivariate distribution \eqn{F} of the subject errors \eqn{Pr(X \leq x, Y\leq y|r) = F_2(x, y, r)};
  }
  \item{\code{F_biv_rect}}{

  the function computes the rectangle probabilities from based on \code{F_biv};
  the function has the matrices \code{U} (upper bounds) and \code{L} (lower bounds)
  as well as vector \code{r} containing the correlation coefficients
  corresponding to the bivariate distribution as arguments; the matrices
  \code{U} and \code{L} both have two columns, first corresponding to the bounds of x,
  second to the bounds of y; the number of rows corresponds to the number of observations;
  the rectangle probabilities are defined as
  \eqn{Pr(L[,1]\leq X\leq U[,1], L[,2]\leq Y \leq U[,2]|r) = F_2(U[,1], U[,2],r) - F_2(U[,1], L[,2],r)- F_2(L[,1], U[,2],r) + F_2(L[,1], L[,2],r)}
  }
  \item{\code{F_multi}}{

  the function computes the multivariate probabilities for distribution function \eqn{F};
  the function has the matrices \code{U} (upper bounds) and \code{L} (lower bounds)
  as well as the list \code{list_R} containing for each observation the correlation matrix;
  F is needed for the computation of the fitted/predicted joint probabilities.  If NULL only marginal probabilities can be computed.
  }
  \item{\code{deriv.fun}}{

  (needed for computation of analytic standard errors) a list containing the following gradient functions:
        \describe{
           \item{\code{dF1dx}}{ derivative \eqn{dF_1(x)/dx} function,}
           \item{\code{dF2dx}}{ derivative \eqn{dF_2(x,y,r)/dx} function,}
           \item{\code{dF2dr}}{ derivative \eqn{dF_2(x,y,r)/dr } function.}
         }
  If \code{deriv.fun = NULL} numeric standard errors will be computed.
  }
}
}
\description{
Different \code{link} functions are available in \pkg{mvord}:
}
\details{
We allow for two different link functions, the multivariate probit
link and the multivariate logit link.
For the multivariate probit
link a multivariate normal distribution for the errors is applied. The
normal bivariate probabilities which enter the pairwise log-likelihood
are computed with the package \pkg{pbivnorm}.

For the multivariate logit link a \eqn{t} copula based multivariate
distribution with logistic margins is used.
  The \code{mvlogit()} function has an optional integer valued argument
\code{df} which specifies the degrees of freedom to be used for the
\eqn{t} copula.  The default value of the degrees of freedom parameter is
8. We restrict the degrees of freedom to be integer valued because the
most efficient routines for computing bivariate \eqn{t} probabilities do
not support non-integer degrees of freedom. For further details see vignette.
}
