% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_base.R
\name{remove_genes}
\alias{remove_genes}
\title{Remove Genes from PhyloExpressionSet}
\usage{
remove_genes(
  phyex_set,
  genes,
  new_name = paste(phyex_set@name, "perturbed"),
  reuse_null_txis = TRUE
)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{genes}{Character vector of gene IDs to remove}

\item{new_name}{Character string for the new dataset name (default: auto-generated)}

\item{reuse_null_txis}{Logical indicating whether to reuse precomputed null conservation TXIs (default: TRUE)}
}
\value{
A PhyloExpressionSet object with the specified genes removed
}
\description{
Remove specified genes from a PhyloExpressionSet object.
}
\examples{
# Remove specific genes
filtered_set <- remove_genes(example_phyex_set, example_phyex_set@gene_ids[1:5], 
                            new_name = "Filtered Dataset")

}
