% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nltt_diff_exact_extinct.R
\name{check_input_event_times}
\alias{check_input_event_times}
\title{Checks that event times are correct}
\usage{
check_input_event_times(event_times, event_times2, time_unit)
}
\arguments{
\item{event_times}{event times of the first phylogeny}

\item{event_times2}{event times of the second phylogeny}

\item{time_unit}{the time unit of the branching times
\itemize{
 \item "ago: " the branching times are postive,
   as these are in time units ago
 \item "since: " the branching times are negative,
   as these are in time units since present
}}
}
\value{
Nothing. Throws error with helpful error message if
\code{event_times} and \code{event_times2} are not correct.
}
\description{
Checks \code{event_times} and \code{event_times2} are of the
  appropriate class and have expected characteristics for correct calculation
  of NLTT in \code{\link{nltt_diff_exact_extinct}}.
}
\author{
Pedro Neves and Richèl Bilderbeek and Thijs Janzen
}
