% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nltt_diff_exact_extinct.R
\name{nltt_diff_exact_extinct}
\alias{nltt_diff_exact_extinct}
\title{Calculates the exact difference between the nLTT
curves of the event times. This includes extinction events.}
\usage{
nltt_diff_exact_extinct(
  event_times,
  species_number,
  event_times2,
  species_number2,
  distance_method = "abs",
  time_unit = "since",
  normalize = TRUE
)
}
\arguments{
\item{event_times}{event times of the first phylogeny}

\item{species_number}{the number of species at each event time of the first
phylogeny}

\item{event_times2}{event times of the second phylogeny}

\item{species_number2}{the number of species at each event time of the second
phylogeny}

\item{distance_method}{how the difference between the two nLTTs is summed
\itemize{
 \item "abs: " the absolute distance between the two nLTTs is summed
 \item "squ: " the squared distance between the two nLTTs is summed
}}

\item{time_unit}{the time unit of the branching times
\itemize{
 \item "ago: " the branching times are postive,
   as these are in time units ago
 \item "since: " the branching times are negative,
   as these are in time units since present
}}

\item{normalize}{should the output be normalized? Default is TRUE.}
}
\description{
Takes branching times such as (for example) as returned by the
  DDD package.
}
\examples{

# Generate data
n <- 10
b_times_n <- (seq(1, n) / n)
lineages_n <- b_times_n
b_times2_n <- b_times_n * b_times_n
lineages2_n <- b_times2_n

# Calculate nLTT
out <- nLTT::nltt_diff_exact_extinct(
  event_times = b_times_n,
  species_number  = lineages_n,
  event_times2 = b_times2_n,
  species_number2 = lineages2_n,
  time_unit = "ago",
  distance_method = "abs"
)

}
\author{
Pedro Neves and Richèl Bilderbeek and Thijs Janzen
}
