% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-higher.R
\name{differentiate_n}
\alias{differentiate_n}
\title{Compute a function value and all derivatives up to order n}
\usage{
differentiate_n(f, x, order)
}
\arguments{
\item{f}{A function of one numeric argument.}

\item{x}{A numeric value at which to differentiate.}

\item{order}{A positive integer: the maximum derivative order.}
}
\value{
A named list with components \code{value}, \code{d1},
\code{d2}, ..., \code{d<order>}.
}
\description{
Evaluates \code{f} at a dual variable seeded for order \code{n},
returning the function value and all derivatives from 1 to \code{n}.
}
\examples{
differentiate_n(sin, pi/4, order = 4)
}
