% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPed.R
\name{simPedMCN}
\alias{simPedMCN}
\title{Middle Class Neighborhood pedigree construction}
\usage{
simPedMCN(pedTemp, g, Nfam = NULL, noff = 2)
}
\arguments{
\item{pedTemp}{A \code{data.frame} pedigree of a template pedigree from which
the middle class neighborhood design should continue. If \code{NULL}, a new
pedigree will be created with \code{Nfam} families.}

\item{g}{Integer number of generations to produce from the middle class
neighborhood design}

\item{Nfam}{Integer number of families with which to start a new pedigree
following the middle class neighborhood design.}

\item{noff}{Integer number of full-sib offspring produced by each family
(must be >=2).}
}
\value{
A \code{data.frame} with columns corresponding to: id, dam, sire, sex,
  and generation. Sex is \code{M} for males and \code{F} for females. The
  first generation produced in the middle class neighborhood scheme is assigned
  a value of \dQuote{1}, with their parents being assigned to generation
  \code{0}. If \code{pedTemp} was provided, the generations from this pedigree
  will be denoted with negative integers.
}
\description{
Simulates a pedigree for the \dQuote{middle class neighborhood} mating design
(Shabalina, Yampolsky, and Kondrashov 1997).
}
\details{
This creates a pedigree following a breeding design which maintains equal
contributions to the next generation by each family in the design. It
effectively removes the effect of natural selection which makes it amenable
to quantify the contribution of mutations to phenotypic variance over the
course of the breeding design.

For a starting pedigree template (\code{pedTemp}), the last generation is used
as parents to begin the breeding design for the next \code{g} generations.
The number of families in the last generation of the template pedigree
(\code{pedTemp}) will be the number of families in each generation.

Alternatively, if no template pedigree is provided (\code{pedTemp=NULL}),
\code{Nfam} number of families will be produced in the first generation from
\code{Nfam} unique sire and \code{Nfam} unique dams.

Either \code{pedTemp} or \code{Nfam} must be \code{NULL}, but not both.
}
\examples{
 # No template pedigree provided - start from scrtach
  mcn1 <- simPedMCN(pedTemp = NULL, g = 3, Nfam = 4, noff = 2)

 # Provide a template pedigree (half-sib design)
  hsped <- simPedHS(s = 2, d = 2, n = 4)
  mcnHS <- simPedMCN(pedTemp = hsped, g = 3)
}
\references{
Shabalina, S.A, L.Y. Yampolsky, and A.S. Kondrashov. 1997. Rapid
decline of fitness in panmictic populations of Drosophila melanogaster
maintained under relaxed natural selection. Proc. Natl. Acad. Sci. USA.
94:13034-13039.
}
\seealso{
\code{\link{simPedHS}}, \code{\link{simPedDFC}}
}
\author{
\email{matthewwolak@gmail.com}
}
