% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_util.R
\name{interact.data}
\alias{interact.data}
\title{Construct Interaction Matrix}
\usage{
interact.data(data, base.cols = NULL, exclude.pair = NULL)
}
\arguments{
\item{data}{a \code{\link{data.frame}} or \code{\link{matrix}} to interact.}

\item{base.cols}{indicates columns from one category.
Interactions among variables from a same base.col will be avoided. For example, if three indicator columns,
"ChannelR", "ChannelC" and "ChannelB", are created from a categorical column "Channel", then the interaction among them
can be excluded by assigning \code{base.cols=c("Channel")}. Multiple \code{base.cols} are possible.}

\item{exclude.pair}{the pairs will be excluded from interactions. This should be a \code{\link{list}} object of pairs.
For example, \code{list(c("a1", "a2"), c("d1", "d2"))}.}
}
\value{
This returns an object of \code{\link{matrix}} which contains interactions.
}
\description{
\code{interact.data} interacts all the data in a \code{\link{data.frame}} or \code{\link{matrix}}.
}
\examples{
df = data.frame(1:3, 4:6, 7:9, 10:12, 13:15);
colnames(df) = c("aa", "bb", "cc", "dd", "aa2");
df

interact.data(df);
interact.data(df, base.cols = "aa");
interact.data(df, base.cols = "aa", exclude.pair = list(c("bb", "cc")));



}
