% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_util.R
\name{make.ncpen.data}
\alias{make.ncpen.data}
\title{Create ncpen Data Structure Using a Formula}
\usage{
make.ncpen.data(formula, data)
}
\arguments{
\item{formula}{(formula) regression formula. Intercept will not be created.}

\item{data}{(numeric matrix or data.frame) contains both y and X.}
}
\value{
List of y vector and x matrix.
  \item{y.vec}{y \code{vector}}
  \item{x.mat}{x \code{matrix}}
}
\description{
This function creates ncpen y \code{vector} and x \code{matrix} from data using formula.
}
\examples{
data = data.frame(y = 1:5, x1 = 6:10, x2 = 11:15);
formula = log(y) ~ log(x1) + x2;
make.ncpen.data(formula, data);

}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee
}
