% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_fold.R
\name{assign_fold}
\alias{assign_fold}
\title{Assign folds for cross-validation}
\usage{
assign_fold(y, folds, seed)
}
\arguments{
\item{y}{Either (i) the vector of outcomes or (ii) a vector such as \code{1:n}}

\item{folds}{Number of folds}

\item{seed}{(optional) set a seed for reproducibility}
}
\value{
A vector of integers indicating fold assignments
}
\description{
If y has only two unique values, fold assignments are chosen so that the
balance between outcomes is the same in each fold. This is useful for
logistic regression and time-to-event data (to balance the fraction of
observations that are censored).
}
\examples{
assign_fold(rnorm(11), 2)
assign_fold(1:41, 7)
assign_fold(1:41, 7) |> table()
data(Heart)
assign_fold(Heart$y, 7) |> head()
assign_fold(Heart$y, 7) |> table(Heart$y)
}
\seealso{
\verb{[cv.ncvreg()]}
}
