% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndjson.R
\name{validate}
\alias{validate}
\title{Validate ndjson file}
\usage{
validate(path, verbose = FALSE)
}
\arguments{
\item{path}{path to file (supports "\code{gz}" files)}

\item{verbose}{display verbose information (filename and line numbers with bad records)}
}
\value{
logical
}
\description{
Given a file of streaming JSON (ndjson) this function reads in the records
and validates that they are all legal JSON records. If the \code{verbose}
parameter is \code{TRUE} and errors are found, the line numbers of the
errant records will be displayed.
}
\examples{
f <- system.file("extdata", "test.json", package="ndjson")
validate(f)

gzf <- system.file("extdata", "testgz.json.gz", package="ndjson")
validate(gzf)
}
\references{
\url{https://ndjson.org/}
}
