% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enum.R
\name{enum}
\alias{enum}
\title{Enumerate}
\usage{
enum(items, hush = FALSE, enumerate = TRUE)
}
\arguments{
\item{items}{The items to be enumerated in the loop.}

\item{hush}{Logical. If \code{TRUE} (default), prints "Loop started." when
executed.}

\item{enumerate}{Logical. If \code{TRUE} (default), adds numbering to the
input vector (in item pairs, see Examples). If \code{FALSE}, returns the
original input.}
}
\value{
Vector with numbers added (if so set).
}
\description{
Aids enumeration and merging (via \code{\link{rbind_loop}}) in
  loops: adds numbers to a vector input, and indicates loop start for
  \code{\link{rbind_loop}}.
}
\examples{

my_vector = c('aa', 'bb', 'cxyz', 'last')

for (item in enum(my_vector)) {
    print(item)
}

# just to show what enum() returns
enum(my_vector)

}
\seealso{
\code{\link{rbind_loop}}
}
