% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_01.R
\name{safety_01}
\alias{safety_01}
\title{Safety-01 Calculation}
\usage{
safety_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  eresponse_24_col,
  confidence_interval = FALSE,
  method = c("wilson", "clopper-pearson"),
  conf.level = 0.95,
  correct = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{Column name containing the unique patient record
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column containing age.}

\item{epatient_16_col}{Column for age units.}

\item{eresponse_05_col}{Column containing response mode codes (e.g., 911
response codes).}

\item{eresponse_24_col}{Column detailing additional response descriptors as
text.}

\item{confidence_interval}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical. If
\code{TRUE}, the function calculates a confidence interval for the proportion
estimate.}

\item{method}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Character. Specifies the
method used to calculate confidence intervals. Options are \code{"wilson"}
(Wilson score interval) and \code{"clopper-pearson"} (exact binomial interval).
Partial matching is supported, so \code{"w"} and \code{"c"} can be used as shorthand.}

\item{conf.level}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Numeric. The confidence
level for the interval, expressed as a proportion (e.g., 0.95 for a 95\%
confidence interval). Defaults to 0.95.}

\item{correct}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Logical. If \code{TRUE},
applies a continuity correction to the Wilson score interval when \code{method = "wilson"}. Defaults to \code{TRUE}.}

\item{...}{optional additional arguments to pass onto \code{dplyr::summarize}.}
}
\value{
A data.frame summarizing results for two population groups (All,
Adults and Peds) with the following columns:
\itemize{
\item \code{pop}: Population type (All, Adults, and Peds).
\item \code{numerator}: Count of incidents meeting the measure.
\item \code{denominator}: Total count of included incidents.
\item \code{prop}: Proportion of incidents meeting the measure.
\item \code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
\item \code{lower_ci}: Lower bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
\item \code{upper_ci}: Upper bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
}
}
\description{
The \code{safety_01} function calculates the proportion of 911 responses where
"lights and sirens" were not used in an EMS dataset. It generates age-based
population summaries, calculating the count and proportion of "lights and
sirens" responses among all incidents, and within adult and pediatric groups.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    eresponse_24 = rep("No Lights or Sirens", 5)
  )

# Run the function
# Return 95\% confidence intervals using the Wilson method
  safety_01(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    eresponse_24_col = eresponse_24,
    confidence_interval = TRUE
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
