% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemtr.R
\name{nemtr}
\alias{nemtr}
\title{Nonparametric Extended Median Test}
\usage{
nemtr(
  dataFrame,
  timing,
  streams,
  VoI = NA,
  type = "long",
  median0 = NA,
  delta = 3
)
}
\arguments{
\item{dataFrame}{A user inputted dataframe, can be wide or long}

\item{timing}{A string of the timing variable name}

\item{streams}{A string of the streams variable name}

\item{VoI}{A string of the Variable of Interest name}

\item{type}{A string of the type of data (default long)}

\item{median0}{A value for expected median}

\item{delta}{A value for delta (default 3)}
}
\value{
A validated dataframe in long format
}
\description{
Take a dataframe, validate it, and then conduct the Nonparametric Extended
Median Test to generate and display a control chart
}
\examples{
set.seed(795014178)
streams <- 20
time <- 60
samples <- 15
mu0 <- 3
delta <- 3
library(dplyr)
turnstiles <- tibble(
  turnstile = rep(rep(1:streams,each=samples),time),
  hour = rep(1:time,each=streams * samples),
  sample = rep(rep(1:samples), times = streams * time),
  waitTime = rexp(streams * time * samples,rate=.22985)
  ) \%>\% mutate(waitTime = if_else(hour == 38, waitTime * 2,waitTime))
nemtr(turnstiles, timing="hour", streams="sample", VoI="waitTime", type="long", median0 = 3)

}
