% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{ttest_filter}
\alias{ttest_filter}
\alias{anova_filter}
\alias{wilcoxon_filter}
\alias{correl_filter}
\title{Univariate filters}
\usage{
ttest_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full"),
  keep_factors = TRUE,
  ...
)

anova_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full"),
  keep_factors = TRUE,
  ...
)

wilcoxon_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full"),
  exact = FALSE,
  keep_factors = TRUE,
  ...
)

correl_filter(
  y,
  x,
  method = "pearson",
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full"),
  keep_factors = TRUE,
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix or dataframe of predictors}

\item{force_vars}{Vector of column names within \code{x} which are always retained
in the model (i.e. not filtered). Default \code{NULL} means all predictors will
be passed to \code{filterFUN}.}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors with
p-values < \code{p_cutoff} are returned.}

\item{p_cutoff}{p value cut-off}

\item{rsq_cutoff}{r^2 cutoff for removing predictors due to collinearity.
Default \code{NULL} means no collinearity filtering. Predictors are ranked based
on t-test. If 2 or more predictors are collinear, the first ranked
predictor by t-test is retained, while the other collinear predictors are
removed. See \code{\link[=collinear]{collinear()}}.}

\item{type}{Type of vector returned. Default "index" returns indices, "names"
returns predictor names, "full" returns a matrix of p values.}

\item{keep_factors}{Logical affecting factors with 3 or more levels.
Dataframes are coerced to a matrix using \link{data.matrix}. Binary
factors are converted to numeric values 0/1 and analysed as such. If
\code{keep_factors} is \code{TRUE} (the default), factors with 3 or more levels are
not filtered and are retained. If \code{keep_factors} is \code{FALSE}, they are
removed.}

\item{...}{optional arguments, including \code{rsq_method} passed to \code{\link[=collinear]{collinear()}}
or arguments passed to \link[matrixTests:wilcoxon]{matrixTests::row_wilcoxon_twosample} in
\code{\link[=wilcoxon_filter]{wilcoxon_filter()}}.}

\item{exact}{Logical whether exact or approximate p-value is calculated.
Default is \code{FALSE} for speed.}

\item{method}{Type of correlation, either "pearson" or "spearman".}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters in order
of t-test p-value. If \code{type} is \code{"full"} full output from
\link[Rfast:ttests]{Rfast::ttests} is returned.
}
\description{
A selection of simple univariate filters using t-test, Wilcoxon test, one-way
ANOVA or correlation (Pearson or Spearman) for ranking variables. These
filters are designed for speed. \code{ttest_filter} uses the \code{Rfast} package,
\code{wilcoxon_filter} (Mann-Whitney) test uses
\link[matrixTests:wilcoxon]{matrixTests::row_wilcoxon_twosample}, \code{anova_filter} uses
\link[matrixTests:oneway]{matrixTests::col_oneway_welch} (Welch's F-test) from the \code{matrixTests}
package. Can be applied to all or a subset of predictors. For mixed datasets
(combined continuous & categorical) see \code{\link[=stat_filter]{stat_filter()}}
}
\examples{
## sigmoid function
sigmoid <- function(x) {1 / (1 + exp(-x))}

## load iris dataset and simulate a binary outcome
data(iris)
dt <- iris[, 1:4]
colnames(dt) <- c("marker1", "marker2", "marker3", "marker4")
dt <- as.data.frame(apply(dt, 2, scale))
y2 <- sigmoid(0.5 * dt$marker1 + 2 * dt$marker2) > runif(nrow(dt))
y2 <- factor(y2, labels = c("C1", "C2"))

ttest_filter(y2, dt)  # returns index of filtered predictors
ttest_filter(y2, dt, type = "name")  # shows names of predictors
ttest_filter(y2, dt, type = "full")  # full results table

data(iris)
dt <- iris[, 1:4]
y3 <- iris[, 5]
anova_filter(y3, dt)  # returns index of filtered predictors
anova_filter(y3, dt, type = "full")  # shows names of predictors
anova_filter(y3, dt, type = "name")  # full results table

}
\seealso{
\code{\link[=lm_filter]{lm_filter()}} \code{\link[=stat_filter]{stat_filter()}}
}
