% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acrylic.R
\docType{data}
\name{acrylic}
\alias{acrylic}
\title{A data frame of an acrylic polymer degradation experiment}
\format{
A 357 by 6 data frame of continuous variables
\describe{
  \item{YI}{Yellowness index of acrylic sample}
  \item{IrradTot}{Total applied solar irradiance}
  \item{IAD1}{Induced Absorbance to Dose of the Fundamental Absorption Edge - Optical absorbance at 275 nm}
  \item{IAD2}{Induced Absorbance to Dose of the Tinuvin light stabilizer doublet peak at 298 nm}
  \item{IAD2p}{Induced Absorbance to Dose of the Tinuvin light stabilizer doublet peak at 339 nm}
  \item{IAD3}{Induced Absorbance to Dose in the yellowing region, at 440 nm}
}
}
\source{
Solar Durability and Lifetime Extension (SDLE) Research Center, Case Western
Reserve University
}
\usage{
data(acrylic)
}
\description{
This data set is from a study of photodegradation of acrylic polymer.
In this work, polymeric samples were exposed to different levels of light exposures and resulting optical changes were determined through optical spectroscopy.
*IrradTot* (total applied irradiance) is the main exogenous variable and *YI* (yellowness index) is the endogenous variable (response).
The other columns in the data set (*IAD1*, *IAD2*, *IAD2p*, and *IAD3*)  are induced absorbance to dose values extracted from optical absorbance spectra as single metrics and used as intermediate unit level endogenous (response) variables in the netSEM analysis.
Photodegradation in a stress and response framework: poly(methyl methacrylate) for solar mirrors and lens. Doi: 10.1117/1.JPE.2.022004
}
\author{
Myles P. Murray, Laura S. Bruckman, Roger H. French
}
\keyword{datasets}
