% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{diffusion-data}
\alias{diffusion-data}
\title{Diffusion Network Datasets}
\value{
No return value (this manual entry only provides information).
}
\description{
Diffusion Network Datasets
}
\details{
The three classic network diffusion datasets included in netdiffuseR are the
medical innovation data originally collected by Coleman, Katz & Menzel (1966);
the Brazilian Farmers collected as part of the three country study implemented
by Everett Rogers (Rogers, Ascroft, & Röling, 1970), and Korean Family Planning
data collected by researchers at the Seoul National University's School of
Public (Rogers & Kincaid, 1981). The table below summarizes the three datasets:

\tabular{lccc}{
	\tab	\bold{Medical Innovation}	\tab	\bold{Brazilian Farmers}	\tab	\bold{Korean Family Planning}	\cr
\emph{Country}	\tab	USA	\tab	Brazil	\tab	Korean	\cr
\emph{# Respondents}	\tab	125 Doctors	\tab	692 Farmers	\tab	1,047 Women	\cr
\emph{# Communities}	\tab	4	\tab	11	\tab	25	\cr
\emph{Innovation}	\tab	Tetracycline	\tab	Hybrid Corn Seed	\tab	Family Planning	\cr
\emph{Time for Diffusion}	\tab	18 Months	\tab	20 Years	\tab	11 Years	\cr
\emph{Year Data Collected}	\tab	1955-1956	\tab	1966	\tab	1973	\cr
\emph{Ave. Time to 50\%}	\tab	6	\tab	16	\tab	7	\cr
\emph{Highest Saturation}	\tab	0.89	\tab	0.98	\tab	0.83	\cr
\emph{Lowest Saturation}	\tab	0.81	\tab	0.29	\tab	0.44	\cr
\emph{Citation}	\tab	Coleman et al (1966)	\tab	Rogers et al (1970)	\tab	Rogers & Kincaid (1981)	\cr
}

All datasets include a column called \emph{study} which is coded as
(1) Medical Innovation (2) Brazilian Farmers, (3) Korean Family Planning.
}
\section{Right censored data}{

By convention, non-adopting actors are coded as one plus the last observed time
of adoption.  Prior empirical event history approaches have used this approach
(Valente, 2005; Marsden and Podolny, 1990) and studies have shown that
omitting such observations leads to biased results (van den Bulte & Iyengar,
2011).
}

\references{
Burt, R. S. (1987). "Social Contagion and Innovation: Cohesion versus
Structural Equivalence". American Journal of Sociology, 92(6), 1287–1335.
\doi{10.1086/228667}

Coleman, J., Katz, E., & Menzel, H. (1966). Medical innovation: A diffusion
study (2nd ed.). New York: Bobbs-Merrill

Granovetter, M., & Soong, R. (1983). Threshold models of diffusion and
collective behavior. The Journal of Mathematical Sociology, 9(October 2013),
165–179. \doi{10.1080/0022250X.1983.9989941}

Rogers, E. M., Ascroft, J. R., & Röling, N. (1970). Diffusion of Innovation
in Brazil, Nigeria, and India. Unpublished Report. Michigan State University,
East Lansing.

Everett M. Rogers, & Kincaid, D. L. (1981). Communication Networks: Toward a
New Paradigm for Research. (C. Macmillan, Ed.). New York; London: Free Press.

Mardsen, P., & Podolny, J. (1990). Dynamic Analysis of Network Diffusion Processes,
J. Weesie, H. Flap, eds. Social Networks Through Time, 197–214.

Marsden, P. V., & Friedkin, N. E. (1993). Network Studies of Social Influence.
Sociological Methods & Research, 22(1), 127–151.
\doi{10.1177/0049124193022001006}

Van den Bulte, C., & Iyengar, R. (2011). Tricked by Truncation: Spurious
Duration Dependence and Social Contagion in Hazard Models. Marketing Science,
30(2), 233–248. \doi{10.1287/mksc.1100.0615}

Valente, T. W. (1991). Thresholds and the critical mass: Mathematical models
of the diffusion of innovations. University of Southern California.

Valente, T. W. (1995). "Network models of the diffusion of innovations" (2nd ed.).
Cresskill N.J.: Hampton Press.

Valente, T. W. (2005). Network Models and Methods for Studying the Diffusion of Innovations.
In Models and Methods in Social Network Analysis, Volume 28 of Structural
Analysis in the Social Sciences (pp. 98–116). New York: Cambridge University Press.
}
\seealso{
Other diffusion datasets: 
\code{\link{brfarmers}},
\code{\link{brfarmersDiffNet}},
\code{\link{fakeDynEdgelist}},
\code{\link{fakeEdgelist}},
\code{\link{fakesurvey}},
\code{\link{fakesurveyDyn}},
\code{\link{kfamily}},
\code{\link{kfamilyDiffNet}},
\code{\link{medInnovations}},
\code{\link{medInnovationsDiffNet}}
}
\author{
Thomas W. Valente
}
\concept{diffusion datasets}
