% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-data.R
\name{ns_get_data}
\alias{ns_get_data}
\alias{ns_get_submissions}
\title{Get data from a form}
\usage{
ns_get_data(form_id, type = NULL)

ns_get_submissions(form_id, type = NULL)
}
\arguments{
\item{form_id}{integer. Number of the form to retrieve}

\item{type}{Character or NULL. One of either "original" or "long".}
}
\value{
data.frame
}
\description{
This function connects to a specific form and fetches all answers.
The responses are placed in a data.frame for easy use.
}
\details{
\describe{
 \item{"original"}{ - Returns data in the same tabular format
     as delivered by Nettskjema.}
 \item{"long"}{ - Returns the data in tall format, where
     there are multiple rows per participant (one per question)
     and each choice is timestamped.}
}
}
\section{Functions}{
\itemize{
\item \code{ns_get_submissions()}: Alternative function name, does the same.

}}
\examples{
\dontshow{
vcr::insert_example_cassette("ns_get_data", package = "nettskjemar")
nettskjemar:::mock_if_no_auth()
}

# Retrieve all data
ns_get_data(123823)

ns_get_data(123823, "long")

\dontshow{
vcr::eject_cassette()
}
}
