% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_aws_call.R
\name{make_aws_call}
\alias{make_aws_call}
\title{Construct AWS S3 Call}
\usage{
make_aws_call(
  path_to_file = "/",
  bucket = "hcp-openaccess",
  region = "us-east-1",
  access_key = NULL,
  secret_key = NULL,
  lifetime_minutes = 5,
  query = NULL,
  verb = "GET",
  sign = TRUE
)
}
\arguments{
\item{path_to_file}{Path to file on HCP S3 Bucket}

\item{bucket}{Bucket to download from}

\item{region}{Region of S3 Bucket}

\item{access_key}{Amazon S3 Access Key}

\item{secret_key}{Amazon S3 Secret Key}

\item{lifetime_minutes}{Time that connection can be opened}

\item{query}{additional query to add to \code{verb} command}

\item{verb}{httr VERB to be used}

\item{sign}{Should the url be signed?}
}
\value{
Character of the url to be passed to \code{httr} `VERB`s
}
\description{
Constructs GET information string for AWS S3 Bucket
}
\examples{
if (have_aws_key()){
path_to_file <- paste0(
   "HCP_900/100206/MNINonLinear/",
   "100206.164k_fs_LR.wb.spec")
result = make_aws_call(path_to_file)
# don't want this stuff printed because it has keys
result$headers$secret_key = NULL
result$headers$access_key = NULL
result$query$AWSAccessKeyId = NULL
result$query$Signature = NULL
result
}
}
