% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_vol.R, R/roi.R, R/sparse_neurovec.R
\name{coords,IndexLookupVol-method}
\alias{coords,IndexLookupVol-method}
\alias{coords,ROIVol-method}
\alias{coords,ROICoords-method}
\alias{coords,AbstractSparseNeuroVec-method}
\title{Extract Coordinates from an IndexLookupVol Object}
\usage{
\S4method{coords}{IndexLookupVol}(x, i)

\S4method{coords}{ROIVol}(x, real = FALSE)

\S4method{coords}{ROICoords}(x, real = FALSE)

\S4method{coords}{ROICoords}(x, real = FALSE)

\S4method{coords}{AbstractSparseNeuroVec}(x, i)
}
\arguments{
\item{x}{An \code{\linkS4class{IndexLookupVol}} object to extract coordinates from}

\item{i}{The index into the lookup volume}

\item{real}{if \code{TRUE}, return coordinates in real world units}
}
\value{
A matrix of coordinates
}
\description{
Extracts the coordinates from an IndexLookupVol object based on a given index.
}
\examples{

space <- NeuroSpace(c(64, 64, 64), c(1, 1, 1), c(0, 0, 0))
ilv <- IndexLookupVol(space, c(1:100))
coords(ilv, 1)  # Extract coordinates for index 1


}
