% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovol.R
\name{map_values}
\alias{map_values}
\alias{map_values,NeuroVol,list-method}
\alias{map_values,NeuroVol,matrix-method}
\title{Map Values from One Set to Another Using a User-supplied Lookup Table}
\usage{
map_values(x, lookup)

\S4method{map_values}{NeuroVol,list}(x, lookup)

\S4method{map_values}{NeuroVol,matrix}(x, lookup)
}
\arguments{
\item{x}{The object from which values will be mapped.}

\item{lookup}{The lookup table. The first column is the "key" and the second column is the "value".}
}
\value{
An object of the same class as \code{x}, in which the original values have been replaced with the lookup table values.
}
\description{
This function maps values from one set to another using a lookup table provided by the user.
}
\examples{
x <- NeuroSpace(c(10, 10, 10), c(1, 1, 1))
vol <- NeuroVol(sample(1:10, 10 * 10 * 10, replace = TRUE), x)

## Lookup table is a list
lookup <- lapply(1:10, function(i) i * 10)
names(lookup) <- 1:10
ovol <- map_values(vol, lookup)

## Lookup table is a matrix. The first column is the key, and the second column is the value
names(lookup) <- 1:length(lookup)
lookup.mat <- cbind(as.numeric(names(lookup)), unlist(lookup))
ovol2 <- map_values(vol, lookup.mat)
all.equal(as.vector(ovol2), as.vector(ovol))

}
