% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/SparseBrainVector.R, R/BrainVector.R
\docType{methods}
\name{subVector}
\alias{subVector}
\alias{subVector,DenseBrainVector,numeric-method}
\alias{subVector,SparseBrainVector,numeric-method}
\title{Generic function to extract a sub-vector from a \code{BrainVector} object.}
\usage{
subVector(x, i, ...)

\S4method{subVector}{SparseBrainVector,numeric}(x, i)

\S4method{subVector}{DenseBrainVector,numeric}(x, i)
}
\arguments{
\item{x}{four-dimensional image}

\item{i}{the indices of the volume(s) to extract}

\item{...}{additional arguments}
}
\value{
a  \code{BrainVector} object that is a sub-vector of the supplied object.
}
\description{
Generic function to extract a sub-vector from a \code{BrainVector} object.
}
\examples{
bvec <- BrainVector(array(rnorm(24*24*24*24), c(24,24,24,24)), BrainSpace(c(24,24,24,24), c(1,1,1)))
vec <- subVector(bvec,1:2)
all.equal(2, dim(vec)[4])

vec <- subVector(bvec, c(1,3,5,7))
all.equal(4, dim(vec)[4])

mask <- LogicalBrainVolume(rep(TRUE, 24*24*24), BrainSpace(c(24,24,24), c(1,1,1)))
svec <- SparseBrainVector(array(rnorm(24*24*24*24), c(24,24,24,24)), 
BrainSpace(c(24,24,24,24), c(1,1,1)), mask)
vec <- subVector(svec, c(1,3,5))
all.equal(3, dim(vec)[4])
}

