# Data validation
.check_neutro_data <- function(data) {
  required_cols <- c("Auxili_min", "Auxili_max", "Study_min", "Study_max")
  if (!all(required_cols %in% names(data))) {
    stop("Data must contain: ", paste(required_cols, collapse = ", "))
  }
  invisible(TRUE)
}

# Theta calculation
.calculate_theta <- function(N_L, N_U, n_L, n_U) {
  if (any(c(N_L, N_U, n_L, n_U) <= 0)) stop("Sizes must be positive")
  list(theta_L = (1/n_L) - (1/N_L), theta_U = (1/n_U) - (1/N_U))
}

#' Format MSE Results
#'
#' Pretty-prints MSE results.
#' @param mse_results Output from calculate_all_mse_neutrosophic
#' @return Formatted string
#' @export
format_mse_results <- function(mse_results) {
  if (!all(c("MSE", "MSE1", "MSE2", "MSE_exp", "MSE_r") %in% names(mse_results))) {
    stop("Invalid MSE results structure")
  }

  sprintf(
    "MSE Results:
    Standard: [%.4f, %.4f]
    Ratio-adjusted: [%.4f, %.4f]
    Kurtosis-adjusted: [%.4f, %.4f]
    Exponential: [%.4f, %.4f]
    Regression: [%.4f, %.4f]",
    mse_results$MSE[1], mse_results$MSE[2],
    mse_results$MSE1[1], mse_results$MSE1[2],
    mse_results$MSE2[1], mse_results$MSE2[2],
    mse_results$MSE_exp[1], mse_results$MSE_exp[2],
    mse_results$MSE_r[1], mse_results$MSE_r[2]
  )
}
