\name{format_mse_results}
\alias{format_mse_results}
\title{Format MSE Results for Neutrosophic Survey Data Analysis}
\usage{
format_mse_results(mse_results)
}
\arguments{
\item{mse_results}{A list containing MSE results from \code{\link{calculate_all_mse_neutrosophic}}}
}
\value{
A formatted character string ready for printing, showing all MSE types with their lower and upper bounds
}
\description{
Formats the output of \code{\link{calculate_all_mse_neutrosophic}} into a human-readable string
that clearly displays all five types of MSE estimates with their interval values.
}
\details{
The function takes the MSE results list and formats it to show:
\itemize{
  \item Standard MSE estimates
  \item Ratio-adjusted MSE estimates
  \item Kurtosis-adjusted MSE estimates
  \item Exponential MSE estimates
  \item Regression MSE estimates
}
}
\examples{
# First calculate MSE results
data(japan_neutro)
metrics <- compute_all_metrics(japan_neutro)
mse <- calculate_all_mse_neutrosophic(
  0.01, 0.02,
  metrics$mean_interval_Y[1], metrics$mean_interval_Y[2],
  metrics$mean_interval_X[1], metrics$mean_interval_X[2],
  metrics$cv_interval_X[1], metrics$cv_interval_X[2],
  metrics$cv_interval_Y[1], metrics$cv_interval_Y[2],
  metrics$correlation_results[1], metrics$correlation_results[2],
  metrics$kurtosis_interval_X[1], metrics$kurtosis_interval_X[2]
)

# Format and print results
cat(format_mse_results(mse))
}
\seealso{
\code{\link{calculate_all_mse_neutrosophic}} for generating the input for this function
}
