% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/group.R
\docType{methods}
\name{group_subset}
\alias{group_subset}
\alias{group_subset-method}
\alias{group_subset,GroupedComposition-method}
\alias{group_subset,GroupedLogRatio-method}
\title{Group-based Subset}
\usage{
group_subset(object, ...)

\S4method{group_subset}{GroupedComposition}(object, which)

\S4method{group_subset}{GroupedLogRatio}(object, which)
}
\arguments{
\item{object}{A \code{\linkS4class{GroupedComposition}} object.}

\item{...}{Currently not used.}

\item{which}{A \code{\link{character}} vector specifying the \link[=group]{groups} of
\code{object} to extract.}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Group-based Subset
}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to compositional data
coda <- as_composition(slides, groups = 2)

## Grouping metadata
group_levels(coda)

group_names(coda)

group_indices(coda)

group_rows(coda)

group_n(coda)

group_size(coda)
}
\seealso{
Other grouping methods: 
\code{\link{group}()},
\code{\link{group_names}()},
\code{\link{group_split}()},
\code{\link{is_assigned}()}
}
\author{
N. Frerebeau
}
\concept{grouping methods}
