% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{var_search}
\alias{var_search}
\title{Search for NHANES Variable by Exact Name}
\usage{
var_search(var)
}
\arguments{
\item{var}{Character. Variable name to search for. Will be automatically
converted to uppercase. Not case-sensitive.}
}
\value{
A character vector of CDC table names containing the variable
(e.g., \code{"DEMO"}, \code{"DEMO_B"}, \code{"DEMO_C"}).
Returns \code{character(0)} if the variable is not found.
}
\description{
A convenience wrapper around \code{nhanesA::nhanesSearchVarName} that
searches for variables by exact variable name match. The function
automatically converts input to uppercase to match NHANES naming conventions.
Use this when you know the variable code; use \code{term_search()} for
text-based searches.
}
\examples{
\donttest{
# Search for specific variable (case-insensitive)
var_search("RIDAGEYR") # Age variable across all DEMO cycles
var_search("BPXSY1") # Systolic blood pressure
}

}
\seealso{
\code{\link{term_search}} for text-based searches,
\code{\link{get_url}} for documentation URLs,
\code{\link[nhanesA]{nhanesSearchVarName}} for the underlying function

Other search and lookup functions: 
\code{\link{get_url}()},
\code{\link{term_search}()}
}
\concept{search and lookup functions}
