% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvatures_matern2.R
\name{curvatures_matern2}
\alias{curvatures_matern2}
\title{Posterior samples of rates of change (gradients and curvatures) for the
 Matern kernel with \eqn{\nu=5/2}}
\usage{
curvatures_matern2(dists.1, dists.2, dists.3, z, phi, sigma2)
}
\arguments{
\item{dists.1}{distance matrix generated from coordinates}

\item{dists.2}{distance of grid from coordinates}

\item{dists.3}{delta = coordinate - grid}

\item{z}{posterior samples of \eqn{Z(s)}}

\item{phi}{posterior samples of \eqn{\phi}}

\item{sigma2}{posterior samples of \eqn{\sigma^2}}
}
\value{
A matrix of posterior samples for the gradient and curvatures. For internal use only.
}
\description{
For internal use only.
}
\examples{
\dontrun{
#####################
# Internal use only #
#####################
# Example usage inside of nimblewomble::sprates()
 CM2 = compileNimble(curvatures_matern2)
 sprates = CM2(dists.1 = distM,
              dists.2 = dist.2,
              dists.3 = dist.3,
              z = z,
              phi = phi,
              sigma2 = sigma2)
}
}
\author{
Aritra Halder <aritra.halder@drexel.edu>, \cr
Sudipto Banerjee <sudipto@ucla.edu>
}
\keyword{curvatures_matern2}
