% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_fit.R
\name{gp_fit}
\alias{gp_fit}
\title{Fit a Gaussian process}
\usage{
gp_fit(
  coords = NULL,
  y = NULL,
  X = NULL,
  kernel = c("matern1", "matern2", "gaussian"),
  niter = NULL,
  nburn = NULL
)
}
\arguments{
\item{coords}{spatial coordinats (supply as a matrix)}

\item{y}{response}

\item{X}{covariates (supply as a matrix without the intercept)}

\item{kernel}{choice of kernel; must be one of "matern1", "matern2", "gaussian"}

\item{niter}{number of iterations}

\item{nburn}{burn-in}
}
\value{
A list of MCMC samples containing the covariance parameters and the parameter estimates with associated 95% credible intervals.
}
\description{
Fits a Gaussian process with the choice of three kernels. Uses `nimble` to generate posterior samples.
}
\examples{
\donttest{
require(nimble)
require(nimblewomble)

set.seed(1)
# Generated Simulated Data
N = 1e2
tau = 1
coords = matrix(runif(2 * N, -10, 10), ncol = 2)
colnames(coords) = c("x", "y")
y = rnorm(N, mean = 20 * sin(sqrt(coords[, 1]^2  + coords[, 2]^2)), sd = tau)
# Posterior samples for theta
mc_sp = gp_fit(coords = coords, y = y, kernel = "matern2")
mc_sp$estimates
}
}
\author{
Aritra Halder <aritra.halder@drexel.edu>, \cr
 Sudipto Banerjee <sudipto@ucla.edu>
}
\keyword{gp_fit}
