% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateY.R
\name{simulateY}
\alias{simulateY}
\title{Simulates values of the dependent variable based on a model fit}
\usage{
simulateY(object, nsim = 1, seed = NULL, ..., verbose = FALSE, sigma)
}
\arguments{
\item{object}{an object with a model fit for which the dependent variable is to be simulated.}

\item{nsim}{number of simulations. By default, \code{nsim = 1}.}

\item{seed}{integer scalar used to initiate the random number generator.}

\item{\dots}{some methods for this generic function may require additional arguments.}

\item{verbose}{logical. If \code{TRUE}, basic information about arguments is provided. By default set to \code{FALSE}.}

\item{sigma}{numeric scalar. Allows simulations employing an alternative value of the scale parameter.}
}
\value{
Numeric matrix with the number of columns determined by the \code{nsim} argument.
}
\description{
This function is generic; method functions can be written to handle specific classes of objects.
}
\examples{

\dontrun{
  library(nlme)
  fm1 <- lme(distance ~ age, data = Orthodont)
  simulateY(fm1)
}
}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
