% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_ss.R
\name{is_ss}
\alias{is_ss}
\title{Determine steady state for pharmacokinetic observations}
\usage{
is_ss(df, ssctrl = ss_control(), half_life = NA)
}
\arguments{
\item{df}{A data frame containing pharmacokinetic data. It should include
columns for ID, EVID, SSflag, TIME, AMT, and tad.}

\item{ssctrl}{A control list consistent with the structure returned by
ss_control(). It specifies the method and thresholds for steady-state
evaluation.}

\item{half_life}{Numeric value representing the drug half-life. Required
when the method in ss_control() is based on half-life or uses a combined
approach.}
}
\value{
A data frame with added columns indicating steady-state status,
the dosing interval for steady-state observations, and the method used
to classify steady state.
}
\description{
Evaluates whether pharmacokinetic observations have reached steady state
based on user-defined control settings. The classification can be based on
a fixed number of doses, the number of half-lives relative to the dosing
interval, or a combination of both criteria.
}
\details{
The function determines steady state by examining each observation in
relation to prior dosing history. The required number of doses is calculated
based on the specified method in ss_control(). Observation times are
evaluated to confirm that dose interval and dose amount variability fall
within acceptable limits and that the time after dose is within the most
recent dosing interval. Observations manually marked as steady state using
SSflag are also recognized as steady state.
}
\examples{
dat <- pheno_sd
dat <- processData(dat)$dat
out <- is_ss(df = dat)
out[out$SteadyState == TRUE & !is.na(out$SteadyState),
    c("ID", "TIME", "DV", "EVID", "SteadyState")]

}
\seealso{
ss_control()
}
