% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npd_modelcodes.R
\name{Fit_1cmpt_oral}
\alias{Fit_1cmpt_oral}
\title{Fit oral pharmacokinetic data to a one-compartment linear elimination model}
\usage{
Fit_1cmpt_oral(
  data,
  est.method,
  input.ka,
  input.cl,
  input.vd,
  input.add,
  return.pred.only = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame containing oral pharmacokinetic data formatted for nlmixr2,}

\item{est.method}{Estimation method to use in nlmixr2. Must be one of:
\code{"rxSolve"}, \code{"nls"}, \code{"nlm"}, \code{"nlminb"}, or \code{"focei"}.}

\item{input.ka}{Initial estimate of the absorption rate constant (ka).}

\item{input.cl}{Initial estimate of clearance (CL).}

\item{input.vd}{Initial estimate of volume of distribution (V).}

\item{input.add}{Initial estimate of the additive residual error.}

\item{return.pred.only}{Logical; if \code{TRUE}, returns a data frame with
only predicted concentrations (\code{cp}) for all observations in the input data.}

\item{...}{Additional arguments passed to \code{nlmixr2()}, such as a user-defined
\code{control = foceiControl(...)} or other control settings.}
}
\value{
If \code{return.pred.only = TRUE}, returns a \code{data.frame}
with a single column \code{cp} (predicted concentrations).
Otherwise, returns a fitted model object produced by nlmixr2.
}
\description{
Fits oral pharmacokinetic data to a one-compartment model with
first-order absorption and first-order elimination using the naive pooled data approach.
Supports multiple estimation methods provided by nlmixr2 and can optionally return
only predicted concentrations to support efficient simulation workflows.
}
\examples{
\donttest{
dat <- Oral_1CPT
# Fit using 'nls'
Fit_1cmpt_oral(
  data = dat,
  est.method = "nls",
  input.ka = 1,
  input.cl = 4,
  input.vd = 70,
  input.add = 10
)
# Return only predicted concentrations
Fit_1cmpt_oral(
  data = dat,
  est.method = "rxSolve",
  input.ka = 1,
  input.cl = 4,
  input.vd = 70,
  input.add = 0,
  return.pred.only = TRUE
)
}
}
\author{
Zhonghui Huang
}
