% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_ka.R
\name{ka_calculation_md}
\alias{ka_calculation_md}
\title{Calculate absorption rate constant (ka) in a multiple-dose one-compartment model}
\usage{
ka_calculation_md(cl, ke, t, Ct, Fbio = 1, Dose, tau)
}
\arguments{
\item{cl}{Numeric. Clearance of the drug (in L/hr).}

\item{ke}{Numeric. Elimination rate constant (in 1/hr).}

\item{t}{Numeric. Time after the last dose (in hours) at which the concentration is measured.}

\item{Ct}{Numeric. Observed concentration of the drug at time \code{t} (in mg/L).}

\item{Fbio}{Numeric. Bioavailability fraction (default = 1, meaning 100\% bioavailability).}

\item{Dose}{Numeric. Administered dose of the drug (in mg).}

\item{tau}{Numeric. Dosing interval (in hours) between successive doses.}
}
\value{
A list containing the following components:
\item{ka}{The calculated absorption rate constant.}
\item{full_solution}{The full solution object returned by the \code{uniroot()}
function, which includes additional details about the root-finding process.}
}
\description{
This estimates the absorption rate constant in a multiple-dose oral model using
first-order pharmacokinetics.
}
\details{
The value of ka is obtained numerically using the uniroot unction by solving
the following equation:

\deqn{Ct = \frac{Fbio \cdot Dose \cdot ka}{Vd \cdot (ka - ke)} \left(
\frac{e^{-ke \cdot t}}{1 - e^{-ke \cdot \tau}} - \frac{e^{-ka \cdot t}}{1 -
e^{-ka \cdot \tau}} \right)}

ka is estimated using \code{uniroot()}, which solves for the root of the residual
function (predicted Ct - observed Ct) within a bounded interval (ka > ke and ka <= 1000)
}
\examples{
# Example from Oral_1CPT dataset (ID = 1, 5th dose, t = 2 h)
ka_calculation_md(cl = 4, ke = 0.057, t = 2, Ct = 852, Dose = 60000, tau = 24)

}
\author{
Zhonghui Huang
}
