% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEffectCmt.R
\name{addEffectCmtLin}
\alias{addEffectCmtLin}
\title{Add effect compartment}
\usage{
addEffectCmtLin(
  ui,
  ke0 = "ke0",
  cc = "Cc",
  ce = "Ce",
  ek = "Ek",
  effect = "effect"
)
}
\arguments{
\item{ui}{rxode2 model}

\item{ke0}{This is the effect compartment keo rate}

\item{cc}{the concentration value}

\item{ce}{This is the concentration in the effect compartment}

\item{ek}{simulation linear constant}

\item{effect}{the effect variable that will be modeled}
}
\value{
a model with an effect compartment attached
}
\description{
Add effect compartment
}
\examples{

readModelDb("PK_2cmt_no_depot") |>
   addEffectCmtLin()

# Can also be changed to the more typical Emax with constant (estimated) baselie
readModelDb("PK_2cmt_no_depot") |>
  addEffectCmtLin() |>
  convertEmaxHill() |>
  addBaselineConst()

}
\author{
Matthew L. Fidler
}
