% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultCombine.R
\name{defaultCombine}
\alias{defaultCombine}
\alias{snakeCombine}
\alias{camelCombine}
\alias{dotCombine}
\alias{blankCombine}
\title{Default combine strings}
\usage{
defaultCombine(...)

snakeCombine(...)

camelCombine(...)

dotCombine(...)

blankCombine(...)
}
\arguments{
\item{...}{uses default to combine strings}
}
\value{
combined strings
}
\description{
Default combine strings
}
\section{Functions}{
\itemize{
\item \code{snakeCombine()}: use snake_case to combine 2 strings

\item \code{camelCombine()}: use camelCase to combine strings

\item \code{dotCombine()}: use the default method for combining two strings

\item \code{blankCombine()}: combine using a blank separator

}}
\examples{

# default combine

defaultCombine("f", "depot")

defaultCombine(list(c("a", "funny", "c")))

defaultCombine(c("a", "funny", "c"))

# snake combine

snakeCombine("f", "depot")

snakeCombine(list(c("a", "funny", "c")))

snakeCombine(c("a", "funny", "c"))

# dot combine

dotCombine("f", "depot")

dotCombine(list(c("a", "funny", "c")))

dotCombine(c("a", "funny", "c"))

# blank combine

blankCombine("f", "depot")

blankCombine(list(c("a", "funny", "c")))

blankCombine(c("a", "funny", "c"))
}
\author{
Matthew L. Fidler
}
