# nlraa: R package for Nonlinear Regression for Agricultural
# Applications

[![CRAN](http://www.r-pkg.org/badges/version/nlraa)](https://CRAN.R-project.org/package=nlraa)
[![CRAN
downloads total](https://cranlogs.r-pkg.org/badges/grand-total/nlraa)](https://github.com/r-hub/cranlogs.app)
[![CRAN downloads](https://cranlogs.r-pkg.org/badges/nlraa)](https://cran.r-project.org/package=nlraa)

[Documentation](https://femiguez.github.io/nlraa-docs/index.html)

NOTE: the vignettes (nlraa-Oddi-LFMC and nlraa-AgronJ-paper) that used to be distributed with the package have been moved to the documentation above because of CRAN size limits.

[Nonlinear Models (video) - part I](https://www.youtube.com/watch?v=fIQV4JxXnnA)

[Nonlinear Models (video) - part II](https://www.youtube.com/watch?v=6ujBQxKYlwY)

[Nonlinear Models (video) - part III](https://www.youtube.com/watch?v=cDm9UhwGSXo)

To install

> library(remotes) \
> remotes::install_github("femiguez/nlraa") \
> library(nlraa)

This package supports the following publications:

1. Archontoulis, S. V., and F. E. Miguez. 2015. Nonlinear Regression
   Models and Applications in Agricultural
   Research. Agron. J. 107:786-798. \
   https://doi.org/10.2134/agronj2012.0506

2. Miguez, F., S. Archontoulis, H. Dokoohaki 2018. Chapter 15:
   Nonlinear Regression Models and Applications. In: B. Glaz,
   K. M. Yeater, editors, Applied Statistics in Agricultural,
   Biological, and Environmental Sciences, ASA, CSSA, and SSSA,
   Madison, WI. p. 401-448. \
   https://doi.org/10.2134/appliedstatistics.2016.0003

3. Oddi et. al. (2019). A nonlinear mixed-effects modelling approach
   for ecological data: Using temporal dynamics of vegetation moisture
   as an example. Ecology and Evolution. \
   https://doi.org/10.1002/ece3.5543

Some recent publications that cite this package (updated 2025-3-8):

87\. Individual Growth of Sonoran Desert Tortoises (Gopherus morafkai) 
in an Arizona Population: Implications for Conservation and Management.
Roy C. Averill-Murray. https://doi.org/10.2744/CCB-1642.1

86\. Leaf phosphorus concentration as a diagnostic tool for predicting 
grape composition in subtropical viticulture. Stefanello et al. (2025).
https://doi.org/10.1016/j.eja.2025.127555

85\. Chevalère, J., Berthon, M., Rocher, N. et al. A digital safe space 
for learning: how computer-assisted instruction supports students with 
lower academic self-concept. Educ Inf Technol (2025).
https://doi.org/10.1007/s10639-025-13424-9

84\. Approximately 15% of Miscanthus yield is lost at current
commercial cutting heights in Iowa. Petersen et al. (2025).
https://doi.org/10.1002/agg2.70039

83\. Velocity as an overlooked driver in the echolocation behavior of aerial 
hawking vespertilionid bats. Jakobsen, Lasse et al.
Current Biology, Volume 35, Issue 4, 918 - 926.e4.
 https://doi.org/10.1016/j.cub.2024.12.042

82\. Sorghum leaves more residue with a higher decomposition rate than maize.
Parra et al. (2025). European Journal of Agronomy. https://doi.org/10.1016/j.eja.2025.127515

81\. Energy requirements for sustainable human development. 
Ranjan and Kanitkar. (2025). https://doi.org/10.1016/j.esd.2024.101648

80\. Della Chiesa, T., Northrup, D., Miguez, F.E. et al. Reducing greenhouse 
gas emissions from North American soybean production. 
Nat Sustain 7, 1608–1615 (2024). https://doi.org/10.1038/s41893-024-01458-9

79\. The roots of the rotation effect run deep. Nichols et al. (2024).
Field Crops Research. https://doi.org/10.1016/j.fcr.2024.109640

78\. Abramov, A.A., Lakomkin, V.L., Lukoshkova, E.V. et al. Pulmonary 
Arterial Hypertntion Causes Disregultion of Systemic Circulation via 
Supressesion of Baroceptor Control of the Heart Rhytm. 
J Evol Biochem Phys 60, 2098–2115 (2024). 
https://doi.org/10.1134/S0022093024050338

77\. Historical increases of maize leaf area index in the US 
Corn Belt due primarily to plant density increases. George Kalogeropoulos et al.
Field Crops Research (2024). https://doi.org/10.1016/j.fcr.2024.109615

76\. Efficacy of Essential Oil for Maintaining Postharvest Quality 
and Reducing Decay of Peach Fruit. Yuru Chang. (2024).
University of Florida. MS Thesis. 

75\. Carson, R.G., Leemans, A. Quantitative metrics commonly derived 
from diffusion tractography covary with streamline length: 
a characterization and method of adjustment. 
Brain Struct Funct 229, 2431–2444 (2024). 
https://doi.org/10.1007/s00429-024-02854-9

74\. Glocker, B., Mastný, J., Picek, T. et al. Environmental Effects on 
Assimilated Carbon Quantity and Quality in Two Different 
Wet Grassland Plants. Wetlands 44, 91 (2024). 
https://doi.org/10.1007/s13157-024-01853-0

73\. Multistart nonlinear least squares fitting with {gslnls}.
https://jchau.org/2024/07/31/multistart-nonlinear-least-squares-with-gslnls/

72\. Transit Board Diversity and Pandemic Service Cuts in Vulnerable Communities.
Voulgaris et al. (2024). https://doi.org/10.1177/03611981241263346

71\. Planting Practices for Improved Stand Establishment and Yield Potential in Winter Wheat.
James Copeland. (2024). Michigan State University. MS Thesis.

70\. Stomatal behaviour and water relations in ferns and lycophytes across 
habits and habitats. Prats et al. (2024). https://doi.org/10.1093/aobpla/plae041

69\. Increasing Wheat Protein and Yield through Sulfur Fertilization
and Its Relationship with Nitrogen. Roa et al. (2024). 
https://doi.org/10.3390/nitrogen5030037

68\. The finger weeder cultivator for intra-row mechanical weed
control: Effects of uprooting force on selected weed species.
Asaf et al. (2024). Weed Research. https://doi.org/10.1111/wre.12652

67\. Models and sufficiency interpretation for estimating critical soil
test values for the Fertilizer Recommendation Support Tool. Slaton et al.
(2024).  https://doi.org/10.1002/saj2.20704

66\. Developing aboveground biomass yield curves for dominant boreal 
tree species from time series remote sensing data. (2024).
Tompalski et al. https://doi.org/10.1016/j.foreco.2024.121894

65\. Kinetic modelling of anthocyanins and vitamin C degradation in a 
maqui-citrus beverage during storage for different sweeteners and 
pasteurization treatments. (2024). Hernandez-Prieto et al. 
https://doi.org/10.1016/j.lwt.2024.116082

64\. Modelling the dynamics of microbial populations and Salmonella spp. 
in milk kefir. Caballero et al. (2024) https://doi.org/10.1016/j.fbp.2024.04.002

63\. Performance Evaluation of Predictive Models for Coconut Crop Production 
in Karnataka Using Weather Parameters. Harshith et al. (2024).
https://doi.org/10.9734/ijecc/2024/v14i34073

62\. In Vitro Antifungal Activity of White Thyme, Oregano, and Savory Oils 
Against Five Monilinia fructicola Isolates from the Southeastern United States.
Chang et al. (2024). https://doi.org/10.1094/PHP-12-23-0111-RS

61\. Tractography derived quantitative estimates of tissue microstructure 
depend on streamline length: A characterization and method of adjustment. 
Richard G. Carsona and Alexander Leemans. https://arxiv.org/pdf/2403.02102

60\. Identifying existing pattern in area and production of
major food grains in Karnataka using linear and nonlinear statistical models.
Ragini HR and Harshith KV. https://dx.doi.org/10.22271/maths.2024.v9.i1b.1615

59\. Do newer maize hybrids grow roots faster and deeper? Sciarresi et al.
Crop Science (2024).  https://doi.org/10.1002/csc2.21208

58\. Functional principal component analysis as an alternative to mixed-effect models for describing 
sparse repeated measures in presence of missing data. arXiv:2402.10624v1 [stat.ME] 16 Feb 2024.

57\. Schöpke, B., Wesche, K., Tschan, G.F. et al. Plant species richness increase across crop
field–dry grassland edges masks diverging patterns in generalists and specialists. 
Landsc Ecol 39, 39 (2024). https://doi.org/10.1007/s10980-024-01843-x

56\. Fitting Power-Law Relationships in Watershed Science and Analysis, 
with an Example Using the R Language. R. Dan Moore (2024).  
https://doi.org/10.22230/jwsm.2024v7n1a53

55\. Genetic gains in short-season corn hybrids: Grain yield, yield
components, and grain quality traits. King et al. (2024). 
Crop Scences. https://doi.org/10.1002/csc2.21199

54\. High-throughput phenotyping reveals multiple drought responses of wild and cultivated Phaseolinae beans.
Verheyen et al. Volume 15 - 2024 | https://doi.org/10.3389/fpls.2024.1385985

53\. Matavel, C.E., Meyer-Aurich, A. & Piepho, HP. Model-averaging as an accurate approach for ex-post economic 
optimum nitrogen rate estimation. Precision Agric 25, 1324–1339 (2024). 
https://doi.org/10.1007/s11119-024-10113-4

52\. From a point to a range of optimum estimates for maize plant
density and nitrogen rate recommendations. King et al. (2023).
https://doi.org/10.1002/agj2.21516

51\. Askarieh, A., del Río, M., Aldea, J. et al. Radial increment dynamics of Maritime pine (Pinus pinaster Ait.) in pure and mixed stands with Scots pine (Pinus sylvestris L.) under changing environmental conditions. 
Eur J Forest Res 143, 671–686 (2024). https://doi.org/10.1007/s10342-023-01650-0

50\. Moisture and nutrient management for sustainable dryland sunflower production. Loza et al. 2023. https://doi.org/10.21203/rs.3.rs-3697663/v1

49\. Nitrogen fertilizer and pronitridine rates for corn production in the Midwest U.S. Kaur et al. 2023. https://doi.org/10.1016/j.fcr.2023.109200

48\. The changing landscape of paddy cultivation in Andhra Pradesh: A statistical assessment of area, production, and productivity.  https://dx.doi.org/10.22271/maths.2023.v8.i6Sc.1373  

47\. Assessment of Tissue Phosphorus Concentrations and Diagnostic Tools for Phosphorus Nutrition in Corn. Roa and Ruiz Diaz. 2023. 

46\. A New Scenario Framework for Equitable and Climate-Compatible Futures. Ranjan et al. 2023

45\. Microbial race to colonise leaf litter in a littoral-lake environment and its relation to nutrient dynamics. Madaschi et al. 2023. https://doi.org/10.1111/fwb.14173

44\. Enhancing Our Understanding of Optimal Nitrogen Fertilizer Rates for Maize: A Synthesis of Long-Term Experimentation and Crop Modeling. Baum. PhD Thesis. 2023.

43\. Spatial Applications for Improved Nutrient and Agronomic Management in Minnesota Cropping Systems. Nigon, Leanna. PhD Thesis. 2023. 

42\. Genetic improvement of winter wheat (Triticum aestivum L.) grain yield in the Northern Great Plains of North America, 1959–2021, Boehm et al. 2023. https://doi.org/10.1002/csc2.21065

41\. Background matching through fast and reversible melanin-based pigmentation plasticity in tadpoles comes with morphological and antioxidant changes. Liedtke et al. 2023. https://doi.org/10.1038/s41598-023-39107-4

40\. Determining cardinal temperatures for eight cover crop species. Pessotto et al. 2023. https://doi.org/10.1002/agg2.20393

39\. Maximizing winter wheat yield through planting date and seeding rate management. Copeland et al. 2023. https://doi.org/10.1002/cft2.20240

38\. Accelerated leaf appearance and flowering in maize after four decades of commercial breeding. dos Santos et al. 2023. https://doi.org/10.1002/csc2.21044

37\. Irrigated corn grain yield prediction in Florida using active sensors and plant height. Leitao et al. 2023. https://doi.org/10.1016/j.atech.2023.100276

36\. Patterns of regional site index across a North American boreal forest gradient. Montesano et al. 2023. https://doi.org/10.1088/1748-9326/acdcab

35\. Methods for Improving Potassium Fertilizer Recommendations for Corn in South Dakota. Andrew j. Ahlersmeyer. MS Thesis. 2023 

34\. Hemp yield and cannabinoid concentrations under variable nitrogen and potassium fertilizer rates. James et al. 2023.  https://doi.org/10.1002/csc2.20966

33\. nlive: an R Package to facilitate the application of the sigmoidal and random change point mixed models. Capuano and Wagner. https://arxiv.org/pdf/2302.10836.pdf

32\. The Effect of Harvest Date on Temporal Cannabinoid and Biomass Production in the Floral Hemp (Cannabis sativa L.) Cultivars BaOx and Cherry Wine. Linder et al. 2022. . https://doi.org/10.3390/horticulturae8100959

31\. Establishing Transplant Date, Plant Spacing and Harvest Date Recommendations for Floral Hemp Production. Eric Linder. MS Thesis. 2022.

30\. Estimating optimal sampling area for monitoring tropical forest restoration. Londe et al. (2022). Biological Conservation. 
https://doi.org/10.1016/j.biocon.2022.109532

29\. Establishment, Growth, and Morphology of Miscanthus× Giganteus in Farmed Ephemeral Wetlands. Alex Steiner. MS Thesis. 2021.

28\. Anything but Simple: Using Models and Field Studies to Explore the Effects of Cropping System Diversification in the Upper Midwestern United States. Virginia Nichols. PhD Thesis. 2021.

27\. Love under lockdown: How changes in time with partner impacted stress and relationship outcomes during the COVID-19 pandemic. https://doi.org/10.1177/02654075231162599

26\. Mitchell E. Baum, John E. Sawyer, Emerson D. Nafziger, Isaiah Huber, Peter J. Thorburn, Michael J. Castellano, Sotirios V. Archontoulis. Evaluating and improving APSIM's capacity in simulating long-term corn yield response to nitrogen in continuous- and rotated-corn systems, Agricultural Systems,
Volume 207, 2023, https://doi.org/10.1016/j.agsy.2023.103629.

25\. Physical Modes of Action of Fungicides Against Apple Scab: Timing is Everything, but Dose Matters
Vincent Philion, Valentin Joubert, Marc Trapman, and Arne Stensvand.
Published Online:23 Feb 2023https://doi.org/10.1094/PDIS-11-22-2758-RE

24\. Song, S., Ding, Y., Li, W. et al. Mangrove reforestation provides greater blue carbon benefit than afforestation for mitigating global climate change. Nat Commun 14, 756 (2023). https://doi.org/10.1038/s41467-023-36477-1

23\. Bonansea, S.; Ernst, O.R.; Mazzilli, S.R. Baseline for Brassica carinata Components of Nitrogen-Use Efficiency in Southern South America. Agronomy 2023, 13, 412. https://doi.org/10.3390/agronomy13020412

22\. Gonzalo Carracelas, Nicolas Guilpart, Kenneth G. Cassman, Patricio Grassini,
Distinguishing between yield plateaus and yield ceilings: A case study of rice in Uruguay,
Field Crops Research, https://doi.org/10.1016/j.fcr.2023.108808.

21\. McMaster ES, Chen SH, Yap J-YS, Rossetto M (2022) Conservation genomics of Persoonia hirsuta support of management. Research Centre for Ecosystem Resilience, Royal Botanic Garden Sydney.

20\. Alejo Ruiz, Sotirios V. Archontoulis, Lucas Borrás,
Kernel weight relevance in maize grain yield response to nitrogen fertilization,
Field Crops Research, Volume 286, 2022, 108631,
https://doi.org/10.1016/j.fcr.2022.108631.

19\. Miguez, F. E., & Poffenbarger, H. (2022). How can we estimate optimum fertilizer rates with accuracy and precision? Agricultural & Environmental Letters, 7, e20075. https://doi.org/10.1002/ael2.20075

18\. Pearce, A.W., Slaton, N.A., Lyons, S.E., Bolster, C.H., Bruulsema, T.W., Grove, J.H., Jones, J.D., McGrath, J.M., Miguez, F.E., Nelson, N.O., Osmond, D.L., Parvej, M.R., Pena-Yewtukhiw, E.M. and Spargo, J.T. (2022), Defining relative yield for soil test correlation and calibration trials in the fertilizer recommendation support tool. Soil Sci. Soc. Am. J.. Accepted Author Manuscript. https://doi.org/10.1002/saj2.20450

17\. Rebecca L. Atkins, Kathleen M. Clancy, William T. Ellis, and Craig W. Osenberg. 
Thermal Traits Vary with Mass and across Populations of the Marsh Periwinkle, Littoraria irrorata.
The Biological Bulletin. 2022. https://doi.org/10.1086/719850

16\. Guamani-Quimis, Lenin A., Ariolfo L. Solís-Bowen, Diego Portalanza, and Felipe R. Garcés-Fiallos. 2022. Can Mathematical Models Describe Spear Rot Progress in Oil Palm Trees? A Five-Year Black Weevil-Disease Assessment from Ecuador. Agriculture 12, no. 2: 257. https://doi.org/10.3390/agriculture12020257

15\. Nichols, V. A., Moore, E. B., Gailans, S., Kaspar, T. C., & Liebman, M. (2022). Site-specific effects of winter cover crops on soil water storage. Agrosyst Geosci Environ, 5:e220238. https://doi.org/10.1002/agg2.20238

14\. Positive associations of soil organic matter and crop yields across a regional network of working farms. Emily E. Oldfield, Mark A. Bradford, Abigail J. Augarten, Eric T. Cooley, Amber M. Radatz, Timothy Radatz, Matthew D. Ruark. Soil Science Society of America. 2021.  https://doi.org/10.1002/saj2.20349

13\. Improvement of the Mass-Rearing Protocols for the South American Fruit Fly for Application of the Sterile Insect Technique. Mastrangelo et al. Insects 2021, 12(7), 622; https://doi.org/10.3390/insects12070622

12\. High-yielding sugarcane in tropical Brazil – Integrating field experimentation and modelling approach for assessing variety performances. Henrique Boriolo Dias, Geoff Inman-Bamber, Paulo Cesar Sentelhas, Yvette Everingham, Rodrigo Bermejo, Diomedes Christodoulou. Field Crops Research. 2021. https://doi.org/10.1016/j.fcr.2021.108323.

11\. Evaluation of mehlich-3 for determination of cation exchange capacity in Kansas soils. Edmond Bryan Rutter, Dorivar Ruiz Diaz,Lynn M. Hargrave. 2021. Soil Science Society of America. https://doi.org/10.1002/saj2.20354

10\. Effects of human disturbance on postnatal growth and baseline corticosterone in a long-lived bird. Hannah Watson, Pat Monaghan, Britt J Heidinger, Mark Bolton. Conservation Physiology, Volume 9, Issue 1, 2021. https://doi.org/10.1093/conphys/coab052

9\. The use of R in photosynthesis research. Yasi Liu, Xiangping Wang, Dayong Fan and Jiangshan Lai. Functional Plant Biology 1-8 https://doi.org/10.1071/FP21102

8\. Topographic effects on soil microclimate and surface cover crop residue decomposition in rolling cropland. Sam J. Leuthold, Dan Quinn, Fernando Miguez, Ole Wendroth, Monsterrat Salmerón, Hanna Poffenbarger. Agriculture, Ecosystems & Environment, Volume 320, 2021. https://doi.org/10.1016/j.agee.2021.107609.

7\. Long-term no-till increases soil nitrogen mineralization but does not affect 
optimal corn nitrogen fertilization practices relative to inversion tillage. 
Lucas Pecci Canisares, John Grove, Fernando Miguez and Hanna Poffenbarger. 
Soil and Tillage Research. Volume 213. 2021. 105080. https://doi.org/10.1016/j.still.2021.105080.

6\. Rotating maize reduces the risk and rate of nitrate leaching. 
Heather Randolph Pasley, Nichols Virginia, Michael J Castellano, Matthew J Helmers, 
Mitchell E Baum, Eileen J Kladivko and Sotirios Archontoulis. 2021. Environmental
Research Letters. https://doi.org/10.1088/1748-9326/abef8f

5\. Abendroth, L.J., Miguez, F.E., Castellano, M.J., Carter, P.R., Messina, 
C.D., Dixon, P.M. and Hatfield, J.L. (2021), Lengthening of maize maturity 
time is not a widespread climate change adaptation strategy in the US Midwest. 
Glob Change Biol. https://doi.org/10.1111/gcb.15565

4\. Interactive effect of glyphosate-based herbicides and organic soil layer 
thickness on growth and reproduction of the tropical earthworm 
Pontoscolex corethrurus (Müller, 1857). Garcia-Perez et al. (2020).
https://doi.org/10.1016/j.apsoil.2020.103648

3\. Cuando la variabilidad varía: Heterocedasticidad y funciones de varianza. 
Oddi, F. J., Miguez, F. E., Benedetti, G. G., & Garibaldi, L. A. (2020). 
Ecología Austral; 30; 438-453.

2\. Short-term effects of integrated tillage systems and cover crop on
agronomic response and soil health in North Central Iowa. Alex Cleveringa. 2020.
MS Thesis. Iowa State University.

1\. The Effects of Agronomic Management and 40 Years of Variety Release on 
Soybean Seed Fill and Yield Components. Kathryn Graf. 2018. MS thesis. 
Purdue University.

Other publications where we have used nonlinear mixed models:

1. Fernando E. Miguez, María Bonita Villamil, Stephen P. Long,
    Germán A. Bollero, Meta-analysis of the effects of management
    factors on Miscanthus × giganteus growth and biomass production,
    Agricultural and Forest Meteorology, Volume 148, Issues 8–9, 2008,
    Pages 1280-1292, ISSN 0168-1923, \
    https://doi.org/10.1016/j.agrformet.2008.03.010. \
	Supporting information: \
	http://miguezlab.agron.iastate.edu/OldWebsite/Research/Miscanthus/MetaMiscan.tar.gz

2. Eichenberger, S., F. Miguez, J. Edwards, and A. Knapp. 2015. Changes
    in Kernel Filling with Selection for Grain Yield in a Maize
    Population. Crop Sci. 55:521-526. \
	https://doi.org/10.2135/cropsci2014.07.0462

3. Stein, M., F. Miguez, and J. Edwards. 2016. Effects of Plant Density
    on Plant Growth before and after Recurrent Selection in
    Maize. Crop Sci. 56:2882-2894. \
	https://doi.org/10.2135/cropsci2015.09.0599

Talks:

2008 ACS meeting.

Slides: \
http://miguezlab.agron.iastate.edu/OldWebsite/Research/Talks/ASA_Miguez.pdf

Data and code: \
http://miguezlab.agron.iastate.edu/OldWebsite/Research/Talks/Barley.zip




