% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalar_mult.R
\name{slm}
\alias{slm}
\alias{\%slm\%}
\title{slm}
\usage{
slm(a, nu)

a \%slm\% nu
}
\arguments{
\item{a}{A real number.}

\item{nu}{A neural network of the type generated by create_nn().}
}
\value{
Returns a neural network that is \eqn{a \triangleright \nu}. This
instantiates as \eqn{a \cdot f(x)} under continuous function activation. More specifically
we define operation as:

Let \eqn{\lambda \in \mathbb{R}}. We will denote by \eqn{(\cdot) \triangleright (\cdot):
\mathbb{R} \times \mathsf{NN} \rightarrow \mathsf{NN}} the function satisfying for all
\eqn{\nu \in \mathsf{NN}} and \eqn{\lambda \in \mathbb{R}} that \eqn{\lambda \triangleright \nu =
\mathsf{Aff}_{\lambda \mathbb{I}_{\mathsf{I}(\nu)},0} \bullet \nu}.
}
\description{
The function that returns the left  scalar multiplication
neural network
}
\examples{

5 |> slm(Prd(2.1, 0.1))
Prd(2.1, 0.1) |> srm(5)

}
\references{
Definition 2.3.4. Jentzen, A., Kuckuck, B., and von Wurstemberger, P. (2023).
Mathematical introduction to deep learning: Methods, implementations,
and theory. \url{https://arxiv.org/abs/2310.20360}.

\emph{Note:} We will have two versions of this operation, a prefix and an
infix version.
}
